/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.inventories;

import com.meteordevelopments.duels-optimised.shaded.morepaperlib.scheduling.ScheduledTask;
import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.config.Config;
import com.meteordevelopments.duels.config.Lang;
import com.meteordevelopments.duels.gui.inventory.InventoryGui;
import com.meteordevelopments.duels.match.DuelMatch;
import com.meteordevelopments.duels.util.Loadable;
import com.meteordevelopments.duels.util.StringUtil;
import com.meteordevelopments.duels.util.TextBuilder;
import com.meteordevelopments.duels.util.gui.AbstractGui;
import com.meteordevelopments.duels.util.gui.GuiListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.chat.ClickEvent;
import org.bukkit.entity.Player;

public class InventoryManager
implements Loadable {
    private final DuelsPlugin plugin;
    private final GuiListener<DuelsPlugin> guiListener;
    private final Map<UUID, InventoryGui> inventories = new HashMap<UUID, InventoryGui>();
    private final Config config;
    private final Lang lang;
    private ScheduledTask expireTask;

    public InventoryManager(DuelsPlugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfiguration();
        this.lang = plugin.getLang();
        this.guiListener = plugin.getGuiListener();
    }

    @Override
    public void handleLoad() {
        this.expireTask = this.plugin.doSyncRepeat(() -> {
            long now = System.currentTimeMillis();
            this.inventories.entrySet().removeIf(entry -> {
                if (now - ((InventoryGui)entry.getValue()).getCreation() >= 300000L) {
                    this.guiListener.removeGui((AbstractGui)entry.getValue());
                    return true;
                }
                return false;
            });
        }, 20L, 100L);
    }

    @Override
    public void handleUnload() {
        this.plugin.cancelTask(this.expireTask);
        this.inventories.clear();
    }

    public InventoryGui get(UUID uuid) {
        return this.inventories.get(uuid);
    }

    public void create(Player player, boolean dead) {
        InventoryGui gui = this.inventories.remove(player.getUniqueId());
        if (gui != null) {
            this.guiListener.removeGui(gui);
        }
        gui = new InventoryGui(this.plugin, player, dead);
        this.guiListener.addGui(gui);
        this.inventories.put(player.getUniqueId(), gui);
    }

    public void handleMatchEnd(DuelMatch match) {
        if (!this.config.isDisplayInventories()) {
            return;
        }
        String color = this.lang.getMessage("DUEL.inventories.name-color");
        TextBuilder builder = TextBuilder.of(this.lang.getMessage("DUEL.inventories.message"));
        Set<Player> players = match.getAllPlayers();
        Iterator<Player> iterator = players.iterator();
        while (iterator.hasNext()) {
            Player player = iterator.next();
            builder.add(StringUtil.color(color + player.getName()), ClickEvent.Action.RUN_COMMAND, "/duel _ " + String.valueOf(player.getUniqueId()));
            if (!iterator.hasNext()) continue;
            builder.add(StringUtil.color(color + ", "));
        }
        builder.send(players);
    }
}

