/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.listeners;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.arena.ArenaImpl;
import com.meteordevelopments.duels.arena.ArenaManagerImpl;
import com.meteordevelopments.duels.party.PartyManagerImpl;
import com.meteordevelopments.duels.util.EventUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;

public class DamageListener
implements Listener {
    private final ArenaManagerImpl arenaManager;
    private final PartyManagerImpl partyManager;

    public DamageListener(DuelsPlugin plugin) {
        this.arenaManager = plugin.getArenaManager();
        this.partyManager = plugin.getPartyManager();
        if (plugin.getConfiguration().isForceAllowCombat()) {
            plugin.doSyncAfter(() -> Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin), 1L);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onDamage(EntityDamageByEntityEvent event) {
        if (!event.isCancelled() || !(event.getEntity() instanceof Player)) {
            return;
        }
        Player damaged = (Player)event.getEntity();
        Player damager = EventUtil.getDamager(event);
        if (damager == null) {
            return;
        }
        ArenaImpl arena = this.arenaManager.get(damaged);
        if (arena == null || !this.arenaManager.isInMatch(damager) || arena.isEndGame() || !this.partyManager.canDamage(damager, damaged)) {
            return;
        }
        event.setCancelled(false);
    }
}

