/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.listeners;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.arena.ArenaManagerImpl;
import com.meteordevelopments.duels.util.compat.CompatUtil;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PotionListener
implements Listener {
    private final DuelsPlugin plugin;
    private final ArenaManagerImpl arenaManager;

    public PotionListener(DuelsPlugin plugin) {
        this.plugin = plugin;
        this.arenaManager = plugin.getArenaManager();
        if (plugin.getConfiguration().isRemoveEmptyBottle()) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        }
    }

    @EventHandler
    public void on(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        if (!this.arenaManager.isInMatch(player)) {
            return;
        }
        ItemStack item = event.getItem();
        if (!item.getType().name().endsWith("POTION")) {
            return;
        }
        DuelsPlugin.getMorePaperLib().scheduling().entitySpecificScheduler((Entity)player).run(() -> {
            if (item.getAmount() <= 1) {
                if (CompatUtil.isPre1_10()) {
                    player.getInventory().setItem(player.getInventory().getHeldItemSlot(), null);
                } else {
                    ItemStack held = player.getInventory().getItemInMainHand();
                    if (held.getType() == Material.GLASS_BOTTLE) {
                        player.getInventory().setItemInMainHand(null);
                    } else {
                        player.getInventory().setItemInOffHand(null);
                    }
                }
            } else {
                player.getInventory().removeItem(new ItemStack[]{new ItemStack(Material.GLASS_BOTTLE, 1)});
            }
        }, null);
    }
}

