/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.player;

import com.google.common.base.Charsets;
import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.config.Config;
import com.meteordevelopments.duels.data.LocationData;
import com.meteordevelopments.duels.data.PlayerData;
import com.meteordevelopments.duels.hook.hooks.EssentialsHook;
import com.meteordevelopments.duels.player.PlayerInfo;
import com.meteordevelopments.duels.shaded.jackson.core.type.TypeReference;
import com.meteordevelopments.duels.teleport.Teleport;
import com.meteordevelopments.duels.util.Loadable;
import com.meteordevelopments.duels.util.Log;
import com.meteordevelopments.duels.util.PlayerUtil;
import com.meteordevelopments.duels.util.io.FileUtil;
import com.meteordevelopments.duels.util.json.JsonUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;

public class PlayerInfoManager
implements Loadable {
    private static final String CACHE_FILE_NAME = "player-cache.json";
    private static final String LOBBY_FILE_NAME = "lobby.json";
    private static final String ERROR_LOBBY_LOAD = "Could not load lobby location!";
    private static final String ERROR_LOBBY_SAVE = "Could not save lobby location!";
    private static final String ERROR_LOBBY_DEFAULT = "Lobby location was not set, using %s's spawn location as default. Use the command /duels setlobby in-game to set the lobby location.";
    private final DuelsPlugin plugin;
    private final Config config;
    private final File cacheFile;
    private final File lobbyFile;
    private final Map<UUID, PlayerInfo> cache = new HashMap<UUID, PlayerInfo>();
    private Teleport teleport;
    private EssentialsHook essentials;
    private Location lobby;

    public PlayerInfoManager(DuelsPlugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfiguration();
        this.cacheFile = new File(plugin.getDataFolder(), CACHE_FILE_NAME);
        this.lobbyFile = new File(plugin.getDataFolder(), LOBBY_FILE_NAME);
        plugin.doSyncAfter(() -> Bukkit.getPluginManager().registerEvents((Listener)new PlayerInfoListener(), (Plugin)plugin), 1L);
    }

    @Override
    public void handleLoad() throws IOException {
        InputStreamReader reader;
        this.teleport = this.plugin.getTeleport();
        this.essentials = this.plugin.getHookManager().getHook(EssentialsHook.class);
        if (FileUtil.checkNonEmpty(this.cacheFile, false)) {
            reader = new InputStreamReader((InputStream)new FileInputStream(this.cacheFile), Charsets.UTF_8);
            try {
                Map data = JsonUtil.getObjectMapper().readValue((Reader)reader, new TypeReference<HashMap<UUID, PlayerData>>(this){});
                if (data != null) {
                    for (Map.Entry entry : data.entrySet()) {
                        this.cache.put((UUID)entry.getKey(), ((PlayerData)entry.getValue()).toPlayerInfo());
                    }
                }
            }
            finally {
                ((Reader)reader).close();
            }
            this.cacheFile.delete();
        }
        if (FileUtil.checkNonEmpty(this.lobbyFile, false)) {
            try {
                reader = new InputStreamReader(Files.newInputStream(this.lobbyFile.toPath(), new OpenOption[0]), Charsets.UTF_8);
                try {
                    this.lobby = JsonUtil.getObjectMapper().readValue((Reader)reader, LocationData.class).toLocation();
                }
                finally {
                    ((Reader)reader).close();
                }
            }
            catch (IOException ex) {
                Log.error(this, ERROR_LOBBY_LOAD, ex);
            }
        }
        if (this.lobby == null || this.lobby.getWorld() == null) {
            World world = (World)Bukkit.getWorlds().get(0);
            this.lobby = world.getSpawnLocation();
            Log.warn(this, String.format(ERROR_LOBBY_DEFAULT, world.getName()));
        }
    }

    @Override
    public void handleUnload() throws IOException {
        Bukkit.getOnlinePlayers().stream().filter(Entity::isDead).forEach(player -> {
            PlayerInfo info = this.remove((Player)player);
            if (info != null) {
                player.spigot().respawn();
                this.teleport.tryTeleport((Player)player, info.getLocation());
                PlayerUtil.reset(player);
                info.restore((Player)player);
            }
        });
        if (this.cache.isEmpty()) {
            return;
        }
        HashMap<UUID, PlayerData> data = new HashMap<UUID, PlayerData>();
        for (Map.Entry<UUID, PlayerInfo> entry : this.cache.entrySet()) {
            data.put(entry.getKey(), PlayerData.fromPlayerInfo(entry.getValue()));
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.cacheFile), Charsets.UTF_8);){
            JsonUtil.getObjectWriter().writeValue(writer, data);
            ((Writer)writer).flush();
        }
        this.cache.clear();
    }

    public boolean setLobby(Player player) {
        boolean bl;
        Location lobby = player.getLocation().clone();
        OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(this.lobbyFile.toPath(), new OpenOption[0]), Charsets.UTF_8);
        try {
            JsonUtil.getObjectWriter().writeValue(writer, (Object)LocationData.fromLocation(lobby));
            ((Writer)writer).flush();
            this.lobby = lobby;
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Writer)writer).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                Log.error(this, ERROR_LOBBY_SAVE, ex);
                return false;
            }
        }
        ((Writer)writer).close();
        return bl;
    }

    public PlayerInfo get(Player player) {
        return this.cache.get(player.getUniqueId());
    }

    public void create(Player player, boolean excludeInventory) {
        PlayerInfo info = new PlayerInfo(player, excludeInventory);
        if (!this.config.isTeleportToLastLocation()) {
            info.setLocation(this.lobby.clone());
        }
        this.cache.put(player.getUniqueId(), info);
    }

    public void create(Player player, boolean excludeInventory, boolean restoreExperience) {
        PlayerInfo info = new PlayerInfo(player, excludeInventory, restoreExperience);
        if (!this.config.isTeleportToLastLocation()) {
            info.setLocation(this.lobby.clone());
        }
        this.cache.put(player.getUniqueId(), info);
    }

    public void create(Player player) {
        this.create(player, false);
    }

    public PlayerInfo remove(Player player) {
        return this.cache.remove(player.getUniqueId());
    }

    @Generated
    public Location getLobby() {
        return this.lobby;
    }

    private class PlayerInfoListener
    implements Listener {
        private PlayerInfoListener() {
        }

        @EventHandler(priority=EventPriority.HIGHEST)
        public void on(PlayerJoinEvent event) {
            Player player = event.getPlayer();
            if (player.isDead()) {
                return;
            }
            PlayerInfo info = PlayerInfoManager.this.remove(player);
            if (info == null) {
                return;
            }
            PlayerInfoManager.this.teleport.tryTeleport(player, info.getLocation());
            info.restore(player);
        }

        @EventHandler(priority=EventPriority.HIGHEST)
        public void on(PlayerRespawnEvent event) {
            Player player = event.getPlayer();
            PlayerInfo info = PlayerInfoManager.this.get(player);
            if (info == null) {
                return;
            }
            event.setRespawnLocation(info.getLocation());
            if (PlayerInfoManager.this.essentials != null) {
                PlayerInfoManager.this.essentials.setBackLocation(player, event.getRespawnLocation());
            }
            PlayerInfoManager.this.plugin.doSyncAfter(() -> {
                if (!player.isOnline()) {
                    return;
                }
                PlayerInfoManager.this.remove(player);
                DuelsPlugin.getMorePaperLib().scheduling().entitySpecificScheduler((Entity)player).run(() -> info.restore(player), null);
            }, 1L);
        }
    }
}

