/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.request;

import com.meteordevelopments.duels.api.arena.Arena;
import com.meteordevelopments.duels.api.kit.Kit;
import com.meteordevelopments.duels.api.request.Request;
import com.meteordevelopments.duels.party.Party;
import com.meteordevelopments.duels.setting.Settings;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class RequestImpl
implements Request {
    private final long creation = System.currentTimeMillis();
    private final UUID sender;
    private final UUID target;
    private final Settings settings;

    RequestImpl(Player sender, Player target, Settings setting) {
        this.sender = sender.getUniqueId();
        this.target = target.getUniqueId();
        this.settings = setting.lightCopy();
    }

    @Override
    @Nullable
    public Kit getKit() {
        return this.settings.getKit();
    }

    @Override
    @Nullable
    public Arena getArena() {
        return this.settings.getArena();
    }

    @Override
    public boolean canBetItems() {
        return this.settings.isItemBetting();
    }

    @Override
    public int getBet() {
        return this.settings.getBet();
    }

    public Party getSenderParty() {
        return this.settings.getSenderParty();
    }

    public Party getTargetParty() {
        return this.settings.getTargetParty();
    }

    public boolean isPartyDuel() {
        return this.settings.isPartyDuel();
    }

    @Generated
    public long getCreation() {
        return this.creation;
    }

    @Override
    @Generated
    public UUID getSender() {
        return this.sender;
    }

    @Override
    @Generated
    public UUID getTarget() {
        return this.target;
    }

    @Generated
    public Settings getSettings() {
        return this.settings;
    }
}

