/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.request;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.api.event.request.RequestSendEvent;
import com.meteordevelopments.duels.config.Config;
import com.meteordevelopments.duels.config.Lang;
import com.meteordevelopments.duels.request.RequestImpl;
import com.meteordevelopments.duels.setting.Settings;
import com.meteordevelopments.duels.util.Loadable;
import com.meteordevelopments.duels.util.TextBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class RequestManager
implements Loadable,
Listener {
    private final Config config;
    private final Lang lang;
    private final Map<UUID, Map<UUID, RequestImpl>> requests = new HashMap<UUID, Map<UUID, RequestImpl>>();

    public RequestManager(DuelsPlugin plugin) {
        this.config = plugin.getConfiguration();
        this.lang = plugin.getLang();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public void handleLoad() {
    }

    @Override
    public void handleUnload() {
        this.requests.clear();
    }

    private Map<UUID, RequestImpl> get(Player player, boolean create) {
        Map<UUID, RequestImpl> cached = this.requests.get(player.getUniqueId());
        if (cached == null && create) {
            cached = new HashMap<UUID, RequestImpl>();
            this.requests.put(player.getUniqueId(), cached);
            return cached;
        }
        return cached;
    }

    public void send(Player sender, Player target, Settings settings) {
        String arena;
        RequestImpl request = new RequestImpl(sender, target, settings);
        RequestSendEvent event = new RequestSendEvent(sender, target, request);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        boolean isParty = request.isPartyDuel();
        this.get(sender, true).put(isParty ? request.getTargetParty().getOwner().getUuid() : target.getUniqueId(), request);
        String kit = settings.getKit() != null ? settings.getKit().getName() : this.lang.getMessage("GENERAL.not-selected");
        String ownInventory = settings.isOwnInventory() ? this.lang.getMessage("GENERAL.enabled") : this.lang.getMessage("GENERAL.disabled");
        String string = arena = settings.getArena() != null ? settings.getArena().getName() : this.lang.getMessage("GENERAL.random");
        if (request.isPartyDuel()) {
            Player targetPartyLeader = request.getTargetParty().getOwner().getPlayer();
            this.lang.sendMessage(Collections.singleton(sender), "COMMAND.duel.party-request.send.sender-party", "owner", sender.getName(), "name", target.getName(), "kit", kit, "own_inventory", ownInventory, "arena", arena);
            this.lang.sendMessage((CommandSender)targetPartyLeader, "COMMAND.duel.party-request.send.receiver-party", "name", sender.getName(), "kit", kit, "own_inventory", ownInventory, "arena", arena);
            this.sendClickableMessage("COMMAND.duel.party-request.send.clickable-text.", sender, Collections.singleton(targetPartyLeader));
        } else {
            int betAmount = settings.getBet();
            String itemBetting = settings.isItemBetting() ? this.lang.getMessage("GENERAL.enabled") : this.lang.getMessage("GENERAL.disabled");
            this.lang.sendMessage((CommandSender)sender, "COMMAND.duel.request.send.sender", "name", target.getName(), "kit", kit, "own_inventory", ownInventory, "arena", arena, "bet_amount", betAmount, "item_betting", itemBetting);
            this.lang.sendMessage((CommandSender)target, "COMMAND.duel.request.send.receiver", "name", sender.getName(), "kit", kit, "own_inventory", ownInventory, "arena", arena, "bet_amount", betAmount, "item_betting", itemBetting);
            this.sendClickableMessage("COMMAND.duel.request.send.clickable-text.", sender, Collections.singleton(target));
        }
    }

    private void sendClickableMessage(String path, Player sender, Collection<Player> targets) {
        TextBuilder.of(this.lang.getMessage(path + "info.text"), null, null, HoverEvent.Action.SHOW_TEXT, this.lang.getMessage(path + "info.hover-text")).add(this.lang.getMessage(path + "accept.text"), ClickEvent.Action.RUN_COMMAND, "/duel accept " + sender.getName(), HoverEvent.Action.SHOW_TEXT, this.lang.getMessage(path + "accept.hover-text")).add(this.lang.getMessage(path + "deny.text"), ClickEvent.Action.RUN_COMMAND, "/duel deny " + sender.getName(), HoverEvent.Action.SHOW_TEXT, this.lang.getMessage(path + "deny.hover-text")).send(targets);
    }

    public RequestImpl get(Player sender, Player target) {
        Map<UUID, RequestImpl> cached = this.get(sender, false);
        if (cached == null) {
            return null;
        }
        RequestImpl request = cached.get(target.getUniqueId());
        if (request == null) {
            return null;
        }
        if (System.currentTimeMillis() - request.getCreation() >= (long)this.config.getExpiration() * 1000L) {
            cached.remove(target.getUniqueId());
            return null;
        }
        return request;
    }

    public boolean has(Player sender, Player target) {
        return this.get(sender, target) != null;
    }

    public RequestImpl remove(Player sender, Player target) {
        Map<UUID, RequestImpl> cached = this.get(sender, false);
        if (cached == null) {
            return null;
        }
        RequestImpl request = cached.remove(target.getUniqueId());
        if (request == null) {
            return null;
        }
        if (System.currentTimeMillis() - request.getCreation() >= (long)this.config.getExpiration() * 1000L) {
            cached.remove(target.getUniqueId());
            return null;
        }
        return request;
    }

    @EventHandler
    public void on(PlayerQuitEvent event) {
        this.requests.remove(event.getPlayer().getUniqueId());
    }
}

