/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.teleport;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.hook.hooks.EssentialsHook;
import com.meteordevelopments.duels.util.Loadable;
import com.meteordevelopments.duels.util.Log;
import com.meteordevelopments.duels.util.metadata.MetadataUtil;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;

public final class Teleport
implements Loadable,
Listener {
    public static final String METADATA_KEY = "Duels-Teleport";
    private final DuelsPlugin plugin;
    private EssentialsHook essentials;

    public Teleport(DuelsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void handleLoad() {
        this.essentials = this.plugin.getHookManager().getHook(EssentialsHook.class);
        this.plugin.doSyncAfter(() -> this.plugin.registerListener(this), 1L);
    }

    @Override
    public void handleUnload() {
    }

    public void tryTeleport(Player player, Location location) {
        if (location == null || location.getWorld() == null) {
            Log.warn(this, "Could not teleport " + player.getName() + "! Location is null");
            return;
        }
        for (Entity entity : player.getPassengers()) {
            player.removePassenger(entity);
        }
        player.closeInventory();
        if (this.essentials != null) {
            this.essentials.setBackLocation(player, location);
        }
        MetadataUtil.put(this.plugin, (Entity)player, METADATA_KEY, location.clone());
        boolean isFolia = DuelsPlugin.getMorePaperLib().scheduling().isUsingFolia();
        if (isFolia) {
            player.teleportAsync(location).thenAccept(success -> {
                if (!success.booleanValue()) {
                    Log.warn(this, "Could not teleport " + player.getName() + "! TeleportAsync failed.");
                }
            });
        } else if (!player.teleport(location)) {
            Log.warn(this, "Could not teleport " + player.getName() + "! Player is dead or is vehicle");
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        Object value = MetadataUtil.removeAndGet(this.plugin, (Entity)player, METADATA_KEY);
        if (!event.isCancelled() || value == null) {
            return;
        }
        event.setCancelled(false);
        event.setTo((Location)value);
    }
}

