/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.util;

import java.lang.reflect.Field;
import java.util.Arrays;

public final class EnumUtil {
    private EnumUtil() {
    }

    public static <E> E getByName(String name, Class<E> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        if (clazz.isEnum()) {
            return Arrays.stream(clazz.getEnumConstants()).filter(type -> type.toString().equalsIgnoreCase(name)).findFirst().orElse(null);
        }
        try {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (field.getType() != clazz || !field.getName().equalsIgnoreCase(name)) continue;
                return (E)field.get(null);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to access static field in " + clazz.getName(), e);
        }
        return null;
    }
}

