/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.util.yaml;

import org.bukkit.configuration.file.YamlConstructor;
import org.bukkit.configuration.file.YamlRepresenter;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public final class YamlUtil {
    private static final transient Yaml BUKKIT_YAML;
    private static final transient Yaml YAML;

    private YamlUtil() {
    }

    public static String yamlDump(Object object) {
        return YAML.dump(object);
    }

    public static String bukkitYamlDump(Object object) {
        return BUKKIT_YAML.dump(object);
    }

    public static <T> T yamlLoad(String yaml) {
        return (T)YAML.load(yaml);
    }

    public static <T> T bukkitYamlLoad(String yaml) {
        return (T)BUKKIT_YAML.load(yaml);
    }

    public static <T> T yamlLoadAs(String yaml, Class<T> type) {
        return (T)YAML.loadAs(yaml, type);
    }

    public static <T> T bukkitYamlLoadAs(String yaml, Class<T> type) {
        return (T)BUKKIT_YAML.loadAs(yaml, type);
    }

    static {
        DumperOptions options = new DumperOptions();
        options.setIndent(2);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        YamlRepresenter yamlRepresenter = new YamlRepresenter();
        yamlRepresenter.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        BUKKIT_YAML = new Yaml((BaseConstructor)new YamlBukkitConstructor(), (Representer)yamlRepresenter, options);
        YAML = new Yaml(options);
    }

    private static class YamlBukkitConstructor
    extends YamlConstructor {
        public YamlBukkitConstructor() {
            this.yamlConstructors.put(new Tag("tag:yaml.org,2002:org.bukkit.inventory.ItemStack"), (Construct)this.yamlConstructors.get(Tag.MAP));
        }
    }
}

