/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.validator;

import com.google.common.collect.ImmutableList;
import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.party.Party;
import com.meteordevelopments.duels.setting.Settings;
import com.meteordevelopments.duels.util.Loadable;
import com.meteordevelopments.duels.util.function.Pair;
import com.meteordevelopments.duels.util.validator.BiValidator;
import com.meteordevelopments.duels.util.validator.TriValidator;
import com.meteordevelopments.duels.util.validator.ValidatorUtil;
import com.meteordevelopments.duels.validator.validators.match.BlacklistedWorldValidator;
import com.meteordevelopments.duels.validator.validators.match.CheckAliveValidator;
import com.meteordevelopments.duels.validator.validators.match.CheckMoveValidator;
import com.meteordevelopments.duels.validator.validators.match.CombatTagValidator;
import com.meteordevelopments.duels.validator.validators.match.DuelZoneValidator;
import com.meteordevelopments.duels.validator.validators.match.ModeValidator;
import com.meteordevelopments.duels.validator.validators.match.PartyValidator;
import com.meteordevelopments.duels.validator.validators.match.PreventCreativeValidator;
import com.meteordevelopments.duels.validator.validators.request.self.SelfBlacklistedWorldValidator;
import com.meteordevelopments.duels.validator.validators.request.self.SelfCheckMatchValidator;
import com.meteordevelopments.duels.validator.validators.request.self.SelfCheckSpectateValidator;
import com.meteordevelopments.duels.validator.validators.request.self.SelfCombatTagValidator;
import com.meteordevelopments.duels.validator.validators.request.self.SelfDuelZoneValidator;
import com.meteordevelopments.duels.validator.validators.request.self.SelfEmptyInventoryValidator;
import com.meteordevelopments.duels.validator.validators.request.self.SelfPreventCreativeValidator;
import com.meteordevelopments.duels.validator.validators.request.target.TargetCanRequestValidator;
import com.meteordevelopments.duels.validator.validators.request.target.TargetCheckMatchValidator;
import com.meteordevelopments.duels.validator.validators.request.target.TargetCheckSelfMatchValidator;
import com.meteordevelopments.duels.validator.validators.request.target.TargetCheckSelfValidator;
import com.meteordevelopments.duels.validator.validators.request.target.TargetCheckSpectateValidator;
import com.meteordevelopments.duels.validator.validators.request.target.TargetHasRequestValidator;
import com.meteordevelopments.duels.validator.validators.request.target.TargetNoRequestValidator;
import com.meteordevelopments.duels.validator.validators.request.target.TargetPartyOwnerValidator;
import com.meteordevelopments.duels.validator.validators.request.target.TargetPartyValidator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.bukkit.entity.Player;

public class ValidatorManager
implements Loadable {
    private final Map<Class<?>, TriValidator<Player, Party, Collection<Player>>> selfValidators = new HashMap();
    private final Map<Class<?>, TriValidator<Pair<Player, Player>, Party, Collection<Player>>> targetValidators = new HashMap();
    private final DuelsPlugin plugin;
    private ImmutableList<TriValidator<Player, Party, Collection<Player>>> duelSelfValidators;
    private ImmutableList<TriValidator<Pair<Player, Player>, Party, Collection<Player>>> duelTargetValidators;
    private ImmutableList<TriValidator<Player, Party, Collection<Player>>> duelAcceptSelfValidators;
    private ImmutableList<TriValidator<Pair<Player, Player>, Party, Collection<Player>>> duelAcceptTargetValidators;
    private ImmutableList<TriValidator<Pair<Player, Player>, Party, Collection<Player>>> duelDenyTargetValidators;
    private ImmutableList<BiValidator<Collection<Player>, Settings>> matchValidators;

    public ValidatorManager(DuelsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void handleLoad() {
        this.selfValidators.put(SelfEmptyInventoryValidator.class, new SelfEmptyInventoryValidator(this.plugin));
        this.selfValidators.put(SelfPreventCreativeValidator.class, new SelfPreventCreativeValidator(this.plugin));
        this.selfValidators.put(SelfBlacklistedWorldValidator.class, new SelfEmptyInventoryValidator(this.plugin));
        this.selfValidators.put(SelfCombatTagValidator.class, new SelfPreventCreativeValidator(this.plugin));
        this.selfValidators.put(SelfDuelZoneValidator.class, new SelfEmptyInventoryValidator(this.plugin));
        this.selfValidators.put(SelfCheckMatchValidator.class, new SelfPreventCreativeValidator(this.plugin));
        this.selfValidators.put(SelfCheckSpectateValidator.class, new SelfEmptyInventoryValidator(this.plugin));
        this.targetValidators.put(TargetCheckSelfValidator.class, new TargetCheckSelfValidator(this.plugin));
        this.targetValidators.put(TargetCanRequestValidator.class, new TargetCanRequestValidator(this.plugin));
        this.targetValidators.put(TargetPartyValidator.class, new TargetPartyValidator(this.plugin));
        this.targetValidators.put(TargetCheckMatchValidator.class, new TargetCheckMatchValidator(this.plugin));
        this.targetValidators.put(TargetCheckSelfMatchValidator.class, new TargetCheckSelfMatchValidator(this.plugin));
        this.targetValidators.put(TargetCheckSpectateValidator.class, new TargetCheckSpectateValidator(this.plugin));
        this.targetValidators.put(TargetNoRequestValidator.class, new TargetNoRequestValidator(this.plugin));
        this.targetValidators.put(TargetHasRequestValidator.class, new TargetHasRequestValidator(this.plugin));
        this.targetValidators.put(TargetPartyOwnerValidator.class, new TargetPartyOwnerValidator(this.plugin));
        this.duelSelfValidators = ValidatorUtil.buildList(this.self(SelfEmptyInventoryValidator.class), this.self(SelfPreventCreativeValidator.class), this.self(SelfBlacklistedWorldValidator.class), this.self(SelfCombatTagValidator.class), this.self(SelfDuelZoneValidator.class), this.self(SelfCheckMatchValidator.class), this.self(SelfCheckSpectateValidator.class));
        this.duelTargetValidators = ValidatorUtil.buildList(this.target(TargetCheckSelfValidator.class), this.target(TargetCanRequestValidator.class), this.target(TargetPartyValidator.class), this.target(TargetCheckMatchValidator.class), this.target(TargetCheckSpectateValidator.class), this.target(TargetHasRequestValidator.class), this.target(TargetPartyOwnerValidator.class));
        this.duelAcceptSelfValidators = this.duelSelfValidators;
        this.duelAcceptTargetValidators = ValidatorUtil.buildList(this.target(TargetCheckSelfValidator.class), this.target(TargetPartyValidator.class), this.target(TargetCheckMatchValidator.class), this.target(TargetCheckSelfMatchValidator.class), this.target(TargetCheckSpectateValidator.class), this.target(TargetNoRequestValidator.class), this.target(TargetPartyOwnerValidator.class));
        this.duelDenyTargetValidators = ValidatorUtil.buildList(this.target(TargetNoRequestValidator.class));
        this.matchValidators = ValidatorUtil.buildList(new ModeValidator(this.plugin), new CheckAliveValidator(this.plugin), new PreventCreativeValidator(this.plugin), new BlacklistedWorldValidator(this.plugin), new CheckMoveValidator(this.plugin), new CombatTagValidator(this.plugin), new DuelZoneValidator(this.plugin), new PartyValidator(this.plugin));
    }

    @Override
    public void handleUnload() {
        this.selfValidators.clear();
        this.targetValidators.clear();
    }

    private TriValidator<Player, Party, Collection<Player>> self(Class<? extends TriValidator<Player, Party, Collection<Player>>> clazz) {
        return this.selfValidators.get(clazz);
    }

    private TriValidator<Pair<Player, Player>, Party, Collection<Player>> target(Class<? extends TriValidator<Pair<Player, Player>, Party, Collection<Player>>> clazz) {
        return this.targetValidators.get(clazz);
    }

    @Generated
    public ImmutableList<TriValidator<Player, Party, Collection<Player>>> getDuelSelfValidators() {
        return this.duelSelfValidators;
    }

    @Generated
    public ImmutableList<TriValidator<Pair<Player, Player>, Party, Collection<Player>>> getDuelTargetValidators() {
        return this.duelTargetValidators;
    }

    @Generated
    public ImmutableList<TriValidator<Player, Party, Collection<Player>>> getDuelAcceptSelfValidators() {
        return this.duelAcceptSelfValidators;
    }

    @Generated
    public ImmutableList<TriValidator<Pair<Player, Player>, Party, Collection<Player>>> getDuelAcceptTargetValidators() {
        return this.duelAcceptTargetValidators;
    }

    @Generated
    public ImmutableList<TriValidator<Pair<Player, Player>, Party, Collection<Player>>> getDuelDenyTargetValidators() {
        return this.duelDenyTargetValidators;
    }

    @Generated
    public ImmutableList<BiValidator<Collection<Player>, Settings>> getMatchValidators() {
        return this.matchValidators;
    }
}

