/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.validator.validators.match;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.hook.hooks.worldguard.WorldGuardHook;
import com.meteordevelopments.duels.setting.Settings;
import com.meteordevelopments.duels.validator.BaseBiValidator;
import java.util.Collection;
import org.bukkit.entity.Player;

public class DuelZoneValidator
extends BaseBiValidator<Collection<Player>, Settings> {
    private static final String MESSAGE_KEY = "DUEL.start-failure.not-in-duelzone";
    private static final String PARTY_MESSAGE_KEY = "DUEL.party-start-failure.not-in-duelzone";
    private final WorldGuardHook worldGuard;

    public DuelZoneValidator(DuelsPlugin plugin) {
        super(plugin);
        this.worldGuard = plugin.getHookManager().getHook(WorldGuardHook.class);
    }

    @Override
    public boolean shouldValidate() {
        return this.config.isDuelzoneEnabled() && this.worldGuard != null;
    }

    private boolean notInDuelZone(Player player, String duelzone) {
        return duelzone != null && !duelzone.equals(this.worldGuard.findDuelZone(player));
    }

    @Override
    public boolean validate(Collection<Player> players, Settings settings) {
        if (players.stream().anyMatch(player -> this.notInDuelZone((Player)player, settings.getDuelzone((Player)player)))) {
            this.lang.sendMessage(players, settings.isPartyDuel() ? PARTY_MESSAGE_KEY : MESSAGE_KEY, new Object[0]);
            return false;
        }
        return true;
    }
}

