/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.command;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.arena.ArenaManagerImpl;
import com.meteordevelopments.duels.betting.BettingManager;
import com.meteordevelopments.duels.config.Config;
import com.meteordevelopments.duels.config.Lang;
import com.meteordevelopments.duels.data.UserManagerImpl;
import com.meteordevelopments.duels.duel.DuelManager;
import com.meteordevelopments.duels.hook.HookManager;
import com.meteordevelopments.duels.inventories.InventoryManager;
import com.meteordevelopments.duels.kit.KitManagerImpl;
import com.meteordevelopments.duels.party.PartyManagerImpl;
import com.meteordevelopments.duels.player.PlayerInfoManager;
import com.meteordevelopments.duels.queue.QueueManager;
import com.meteordevelopments.duels.queue.sign.QueueSignManagerImpl;
import com.meteordevelopments.duels.request.RequestManager;
import com.meteordevelopments.duels.setting.SettingsManager;
import com.meteordevelopments.duels.spectate.SpectateManagerImpl;
import com.meteordevelopments.duels.util.command.AbstractCommand;
import com.meteordevelopments.duels.validator.ValidatorManager;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;

public abstract class BaseCommand
extends AbstractCommand<DuelsPlugin> {
    protected final DuelsPlugin plugin;
    protected final Config config;
    protected final Lang lang;
    protected final UserManagerImpl userManager;
    protected final KitManagerImpl kitManager;
    protected final ArenaManagerImpl arenaManager;
    protected final QueueManager queueManager;
    protected final QueueSignManagerImpl queueSignManager;
    protected final SettingsManager settingManager;
    protected final PlayerInfoManager playerManager;
    protected final SpectateManagerImpl spectateManager;
    protected final BettingManager bettingManager;
    protected final InventoryManager inventoryManager;
    protected final DuelManager duelManager;
    protected final RequestManager requestManager;
    protected final HookManager hookManager;
    protected final PartyManagerImpl partyManager;
    protected final ValidatorManager validatorManager;

    protected BaseCommand(DuelsPlugin plugin, String name, String usage, String description, String permission, int length, boolean playerOnly, String ... aliases) {
        super(plugin, name, usage, description, permission, length, playerOnly, aliases);
        this.plugin = plugin;
        this.config = plugin.getConfiguration();
        this.lang = plugin.getLang();
        this.userManager = plugin.getUserManager();
        this.partyManager = plugin.getPartyManager();
        this.kitManager = plugin.getKitManager();
        this.arenaManager = plugin.getArenaManager();
        this.queueManager = plugin.getQueueManager();
        this.queueSignManager = plugin.getQueueSignManager();
        this.settingManager = plugin.getSettingManager();
        this.playerManager = plugin.getPlayerManager();
        this.spectateManager = plugin.getSpectateManager();
        this.bettingManager = plugin.getBettingManager();
        this.inventoryManager = plugin.getInventoryManager();
        this.duelManager = plugin.getDuelManager();
        this.requestManager = plugin.getRequestManager();
        this.hookManager = plugin.getHookManager();
        this.validatorManager = plugin.getValidatorManager();
    }

    protected BaseCommand(DuelsPlugin plugin, String name, String usage, String description, int length, boolean playerOnly, String ... aliases) {
        this(plugin, name, usage, description, (String)null, length, playerOnly, aliases);
    }

    protected BaseCommand(DuelsPlugin plugin, String name, String permission, boolean playerOnly) {
        this(plugin, name, (String)null, (String)null, permission, -1, playerOnly, new String[0]);
    }

    @Override
    protected void handleMessage(CommandSender sender, AbstractCommand.MessageType type, String ... args) {
        switch (type) {
            case PLAYER_ONLY: {
                super.handleMessage(sender, type, args);
                break;
            }
            case NO_PERMISSION: {
                this.lang.sendMessage(sender, "ERROR.no-permission", "permission", args[0]);
                break;
            }
            case SUB_COMMAND_INVALID: {
                this.lang.sendMessage(sender, "ERROR.command.invalid-sub-command", "command", args[0], "argument", args[1]);
                break;
            }
            case SUB_COMMAND_USAGE: {
                this.lang.sendMessage(sender, "COMMAND.sub-command-usage", "command", args[0], "usage", args[1], "description", args[2]);
            }
        }
    }

    protected List<String> handleTabCompletion(String argument, Collection<String> collection) {
        return collection.stream().filter(value -> value.toLowerCase().startsWith(argument.toLowerCase())).map(value -> value.replace(" ", "-")).collect(Collectors.toList());
    }
}

