/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.command.commands.duels.subcommands;

import com.meteordevelopments.duels-optimised.shaded.paperlib.PaperLib;
import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.arena.ArenaImpl;
import com.meteordevelopments.duels.command.BaseCommand;
import com.meteordevelopments.duels.util.StringUtil;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class TeleportCommand
extends BaseCommand {
    public TeleportCommand(DuelsPlugin plugin) {
        super(plugin, "teleport", "teleport [name] <-2>", "Teleports to an arena.", 2, true, "tp", "goto");
    }

    @Override
    protected void execute(CommandSender sender, String label, String[] args) {
        boolean second = args[args.length - 1].equals("-2");
        String name = StringUtil.join(args, " ", 1, args.length - (second ? 1 : 0)).replace("-", " ");
        ArenaImpl arena = this.arenaManager.get(name);
        if (arena == null) {
            this.lang.sendMessage(sender, "ERROR.arena.not-found", "name", name);
            return;
        }
        if (arena.getPositions().isEmpty()) {
            this.lang.sendMessage(sender, "ERROR.arena.no-position-set", "name", name);
            return;
        }
        int pos = second ? 2 : 1;
        Location location = arena.getPosition(pos);
        if (location == null) {
            this.lang.sendMessage(sender, "ERROR.arena.invalid-position", new Object[0]);
            return;
        }
        PaperLib.teleportAsync((Entity)((Player)sender), location);
        this.lang.sendMessage(sender, "COMMAND.duels.teleport", "name", name, "position", pos);
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 2) {
            return this.handleTabCompletion(args[1], this.arenaManager.getNames());
        }
        return null;
    }
}

