/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.data;

import com.meteordevelopments.duels.shaded.jackson.core.JsonParser;
import com.meteordevelopments.duels.shaded.jackson.databind.DeserializationContext;
import com.meteordevelopments.duels.shaded.jackson.databind.JsonDeserializer;
import com.meteordevelopments.duels.shaded.jackson.databind.JsonNode;
import com.meteordevelopments.duels.util.EnumUtil;
import com.meteordevelopments.duels.util.collection.StreamUtil;
import com.meteordevelopments.duels.util.compat.CompatUtil;
import com.meteordevelopments.duels.util.compat.Identifiers;
import com.meteordevelopments.duels.util.inventory.ItemBuilder;
import com.meteordevelopments.duels.util.inventory.ItemUtil;
import com.meteordevelopments.duels.util.json.DefaultBasedDeserializer;
import com.meteordevelopments.duels.util.yaml.YamlUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.util.Consumer;

public class ItemData {
    private Map<String, Object> item;

    private ItemData() {
    }

    private ItemData(ItemStack item) {
        item = Identifiers.removeIdentifier(item);
        String dumped = YamlUtil.bukkitYamlDump(item);
        this.item = (Map)YamlUtil.yamlLoad(dumped);
    }

    public static ItemData fromItemStack(ItemStack item) {
        return new ItemData(item);
    }

    private static void patchItemFlags(Map<String, Object> item) {
        Map metaAsMap;
        Object itemFlags;
        Object meta = item.get("meta");
        if (meta instanceof Map && (itemFlags = (metaAsMap = (Map)meta).get("ItemFlags")) instanceof Iterable) {
            metaAsMap.put("ItemFlags", StreamUtil.asStream((Iterable)itemFlags).map(Object::toString).collect(Collectors.toSet()));
        }
    }

    public ItemStack toItemStack(boolean kitItem) {
        if (this.item == null || this.item.isEmpty()) {
            return null;
        }
        if (CompatUtil.isPre1_12()) {
            ItemData.patchItemFlags(this.item);
        }
        String dumped = YamlUtil.yamlDump(this.item);
        ItemStack item = YamlUtil.bukkitYamlLoadAs(dumped, ItemStack.class);
        return kitItem ? Identifiers.addIdentifier(item) : item;
    }

    public ItemStack toItemStack() {
        return this.toItemStack(true);
    }

    public static class ItemDataDeserializer
    extends DefaultBasedDeserializer<ItemData> {
        private static boolean checkOldJson = true;

        public ItemDataDeserializer(JsonDeserializer<?> defaultDeserializer) {
            super(ItemData.class, defaultDeserializer);
        }

        @Override
        public ItemData deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            JsonNode node = null;
            JsonParser actual = parser;
            if (checkOldJson) {
                node = (JsonNode)parser.readValueAsTree();
                actual = parser.getCodec().treeAsTokens(node);
                actual.nextToken();
            }
            ItemData data = (ItemData)this.defaultDeserializer.deserialize(actual, context);
            if (data.item != null) {
                checkOldJson = false;
            } else if (node != null) {
                List<String> args;
                PotionType potionType;
                if (!node.isObject()) {
                    return null;
                }
                if (node.has("serializedItem")) {
                    return new ItemData(ItemUtil.itemFrom64(node.get("serializedItem").textValue()));
                }
                String material = node.get("material").textValue();
                int amount = node.has("amount") ? node.get("amount").intValue() : 1;
                short damage = node.has("data") ? node.get("data").shortValue() : (short)0;
                Material type = Material.getMaterial((String)material);
                if (type == null) {
                    return null;
                }
                ItemBuilder builder = ItemBuilder.of(type, amount, damage);
                if (node.has("displayName")) {
                    builder.name(node.get("displayName").textValue());
                }
                if (node.has("lore")) {
                    builder.lore(StreamUtil.asStream(node.get("lore")).map(JsonNode::textValue).collect(Collectors.toList()));
                }
                if (node.has("enchantments")) {
                    JsonNode enchantments = node.get("enchantments");
                    StreamUtil.asStream(enchantments.fieldNames()).forEach(entry -> {
                        Enchantment enchantment = Enchantment.getByName((String)entry);
                        if (enchantment == null) {
                            return;
                        }
                        builder.enchant(enchantment, enchantments.get((String)entry).asInt());
                    });
                }
                if (node.has("flags") && CompatUtil.hasItemFlag()) {
                    JsonNode flags = node.get("flags");
                    StreamUtil.asStream(flags).forEach(flagNode -> {
                        ItemFlag flag = EnumUtil.getByName(flagNode.textValue(), ItemFlag.class);
                        if (flag == null) {
                            return;
                        }
                        builder.editMeta((Consumer<ItemMeta>)((Consumer)meta -> meta.addItemFlags(new ItemFlag[]{flag})));
                    });
                }
                if (node.has("unbreakable") && node.get("unbreakable").booleanValue()) {
                    builder.unbreakable();
                }
                if (node.has("owner")) {
                    builder.head(node.get("owner").textValue());
                }
                if (node.has("color")) {
                    builder.leatherArmorColor(node.get("color").textValue());
                }
                if (node.has("effects")) {
                    JsonNode effects = node.get("effects");
                    builder.editMeta((Consumer<ItemMeta>)((Consumer)meta -> {
                        PotionMeta potionMeta = (PotionMeta)meta;
                        StreamUtil.asStream(effects.fieldNames()).forEach(entry -> {
                            String[] split = effects.get((String)entry).textValue().split("-");
                            int duration = Integer.parseInt(split[0]);
                            int amplifier = Integer.parseInt(split[1]);
                            PotionEffectType effectType = PotionEffectType.getByName((String)entry);
                            if (effectType == null) {
                                return;
                            }
                            potionMeta.addCustomEffect(new PotionEffect(effectType, duration, amplifier), true);
                        });
                    }));
                }
                if (node.has("itemData") && !CompatUtil.isPre1_9() && (potionType = EnumUtil.getByName((args = Arrays.asList(node.get("itemData").textValue().split("-"))).get(0), PotionType.class)) != null) {
                    builder.potion(potionType, args.contains("extended"), args.contains("strong"));
                }
                if (node.has("attributeModifiers") && CompatUtil.hasAttributes()) {
                    JsonNode attributes = node.get("attributeModifiers");
                    StreamUtil.asStream(attributes).forEach(attributeNode -> builder.attribute(attributeNode.get("name").textValue(), attributeNode.get("operation").intValue(), attributeNode.get("amount").doubleValue(), attributeNode.has("slot") ? attributeNode.get("slot").textValue() : null));
                }
                return new ItemData(builder.build());
            }
            return data;
        }
    }
}

