/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.data;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.data.LocationData;
import com.meteordevelopments.duels.kit.KitImpl;
import com.meteordevelopments.duels.queue.Queue;
import com.meteordevelopments.duels.queue.sign.QueueSignImpl;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;

public class QueueSignData {
    private LocationData location;
    private String kit;
    private int bet;

    private QueueSignData() {
    }

    public QueueSignData(QueueSignImpl sign) {
        this.location = LocationData.fromLocation(sign.getLocation());
        Queue queue = sign.getQueue();
        this.kit = queue.getKit() != null ? queue.getKit().getName() : null;
        this.bet = queue.getBet();
    }

    public QueueSignImpl toQueueSign(DuelsPlugin plugin) {
        Location location = this.location.toLocation();
        if (location.getWorld() == null) {
            return null;
        }
        Block block = location.getBlock();
        if (!(block.getState() instanceof Sign)) {
            return null;
        }
        KitImpl kit = this.kit != null ? plugin.getKitManager().get(this.kit) : null;
        Queue queue = plugin.getQueueManager().get(kit, this.bet);
        if (queue == null) {
            plugin.getQueueManager().create(kit, this.bet);
            queue = plugin.getQueueManager().get(kit, this.bet);
        }
        return new QueueSignImpl(location, plugin.getLang().getMessage("SIGN.format", "kit", this.kit != null ? this.kit : plugin.getLang().getMessage("GENERAL.none"), "bet_amount", this.bet), queue);
    }
}

