/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.duel;

import com.meteordevelopments.duels-optimised.shaded.morepaperlib.scheduling.ScheduledTask;
import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.api.event.match.MatchEndEvent;
import com.meteordevelopments.duels.api.event.match.MatchStartEvent;
import com.meteordevelopments.duels.arena.ArenaImpl;
import com.meteordevelopments.duels.arena.ArenaManagerImpl;
import com.meteordevelopments.duels.arena.fireworks.FireworkUtils;
import com.meteordevelopments.duels.config.Config;
import com.meteordevelopments.duels.config.Lang;
import com.meteordevelopments.duels.data.UserManagerImpl;
import com.meteordevelopments.duels.hook.hooks.EssentialsHook;
import com.meteordevelopments.duels.hook.hooks.McMMOHook;
import com.meteordevelopments.duels.hook.hooks.MyPetHook;
import com.meteordevelopments.duels.hook.hooks.VaultHook;
import com.meteordevelopments.duels.hook.hooks.worldguard.WorldGuardHook;
import com.meteordevelopments.duels.inventories.InventoryManager;
import com.meteordevelopments.duels.kit.KitImpl;
import com.meteordevelopments.duels.match.DuelMatch;
import com.meteordevelopments.duels.party.Party;
import com.meteordevelopments.duels.party.PartyManagerImpl;
import com.meteordevelopments.duels.player.PlayerInfo;
import com.meteordevelopments.duels.player.PlayerInfoManager;
import com.meteordevelopments.duels.queue.Queue;
import com.meteordevelopments.duels.queue.QueueManager;
import com.meteordevelopments.duels.setting.Settings;
import com.meteordevelopments.duels.teleport.Teleport;
import com.meteordevelopments.duels.util.Loadable;
import com.meteordevelopments.duels.util.Log;
import com.meteordevelopments.duels.util.PlayerUtil;
import com.meteordevelopments.duels.util.compat.CompatUtil;
import com.meteordevelopments.duels.util.compat.Titles;
import com.meteordevelopments.duels.util.inventory.InventoryUtil;
import com.meteordevelopments.duels.util.validator.ValidatorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.plugin.Plugin;

public class DuelManager
implements Loadable {
    private final DuelsPlugin plugin;
    private final Config config;
    private final Lang lang;
    private final UserManagerImpl userDataManager;
    private final PartyManagerImpl partyManager;
    private final ArenaManagerImpl arenaManager;
    private final PlayerInfoManager playerManager;
    private final InventoryManager inventoryManager;
    private QueueManager queueManager;
    private Teleport teleport;
    private VaultHook vault;
    private EssentialsHook essentials;
    private McMMOHook mcMMO;
    private WorldGuardHook worldGuard;
    private MyPetHook myPet;
    private ScheduledTask durationCheckTask;

    public DuelManager(DuelsPlugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfiguration();
        this.lang = plugin.getLang();
        this.userDataManager = plugin.getUserManager();
        this.partyManager = plugin.getPartyManager();
        this.arenaManager = plugin.getArenaManager();
        this.playerManager = plugin.getPlayerManager();
        this.inventoryManager = plugin.getInventoryManager();
        plugin.doSyncAfter(() -> Bukkit.getPluginManager().registerEvents((Listener)new DuelListener(), (Plugin)plugin), 1L);
    }

    public void handleMatchEnd(DuelMatch match, ArenaImpl arena, Player loser, Location deadLocation, Player winner) {
        DuelsPlugin.getMorePaperLib().scheduling().regionSpecificScheduler(arena.first().getLocation()).runDelayed(() -> {
            if (arena.size() == 0) {
                match.getAllPlayers().forEach(matchPlayer -> {
                    this.handleTie((Player)matchPlayer, arena, match, false);
                    this.lang.sendMessage((CommandSender)matchPlayer, "DUEL.on-end.tie", new Object[0]);
                });
                this.plugin.doSyncAfter(() -> this.inventoryManager.handleMatchEnd(match), 1L);
                arena.endMatch(null, null, MatchEndEvent.Reason.TIE);
                return;
            }
            if (this.config.isSpawnFirework()) {
                DuelsPlugin.getMorePaperLib().scheduling().regionSpecificScheduler(deadLocation).run(() -> {
                    Firework firework = (Firework)deadLocation.getWorld().spawnEntity(deadLocation, EntityType.FIREWORK);
                    FireworkMeta meta = firework.getFireworkMeta();
                    String colourName = this.config.getFireworkColour();
                    String typeName = this.config.getFireworkType();
                    Color colour = FireworkUtils.getColor(colourName);
                    FireworkEffect.Type type = FireworkUtils.getType(typeName);
                    meta.setPower(0);
                    meta.addEffect(FireworkEffect.builder().withColor(colour).with(type).withTrail().build());
                    firework.setFireworkMeta(meta);
                });
            }
            Set<Player> winners = match.getAlivePlayers();
            winners.forEach(w -> this.inventoryManager.create((Player)w, false));
            this.userDataManager.handleMatchEnd(match, winners);
            this.plugin.doSyncAfter(() -> this.inventoryManager.handleMatchEnd(match), 1L);
            DuelsPlugin.getMorePaperLib().scheduling().entitySpecificScheduler((Entity)loser).runDelayed(() -> {
                for (Player alivePlayer : winners) {
                    this.handleWin(alivePlayer, loser, arena, match);
                }
                if (this.config.isEndCommandsEnabled() && (match.isFromQueue() || !this.config.isEndCommandsQueueOnly())) {
                    try {
                        for (String command : this.config.getEndCommands()) {
                            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replace("%winner%", winner.getName()).replace("%loser%", loser.getName()).replace("%kit%", match.getKit() != null ? match.getKit().getName() : "").replace("%arena%", arena.getName()).replace("%bet_amount%", String.valueOf(match.getBet())));
                        }
                    }
                    catch (Exception ex) {
                        Log.warn(this, "Error while running match end commands: " + ex.getMessage());
                    }
                }
                arena.endMatch(winner.getUniqueId(), loser.getUniqueId(), MatchEndEvent.Reason.OPPONENT_DEFEAT);
            }, null, (long)this.config.getTeleportDelay() * 20L);
        }, 1L);
    }

    @Override
    public void handleLoad() {
        this.queueManager = this.plugin.getQueueManager();
        this.teleport = this.plugin.getTeleport();
        this.vault = this.plugin.getHookManager().getHook(VaultHook.class);
        this.essentials = this.plugin.getHookManager().getHook(EssentialsHook.class);
        this.mcMMO = this.plugin.getHookManager().getHook(McMMOHook.class);
        this.myPet = this.plugin.getHookManager().getHook(MyPetHook.class);
        if (this.config.getMaxDuration() > 0) {
            this.durationCheckTask = this.plugin.doSyncRepeat(() -> {
                for (ArenaImpl arena : this.arenaManager.getArenasImpl()) {
                    DuelMatch match = arena.getMatch();
                    if (match == null || match.getDurationInMillis() < (long)(this.config.getMaxDuration() * 60) * 1000L || arena.isEndGame()) continue;
                    ArrayList<Player> members = new ArrayList<Player>(match.getAllPlayers());
                    for (Player player : members) {
                        boolean alive = !match.isDead(player);
                        this.handleTie(player, arena, match, alive);
                        this.lang.sendMessage((CommandSender)player, "DUEL.on-end.tie", new Object[0]);
                    }
                    arena.endMatch(null, null, MatchEndEvent.Reason.MAX_TIME_REACHED);
                }
            }, 1L, 20L);
        }
    }

    @Override
    public void handleUnload() {
        if (this.config.getMaxDuration() > 0) {
            this.plugin.cancelTask(this.durationCheckTask);
        }
        for (ArenaImpl arena : this.arenaManager.getArenasImpl()) {
            boolean winnerDecided;
            DuelMatch match = arena.getMatch();
            if (match == null) continue;
            int size = arena.size();
            boolean bl = winnerDecided = size == 1;
            if (winnerDecided) {
                for (Player winner : match.getAlivePlayers()) {
                    this.lang.sendMessage((CommandSender)winner, "DUEL.on-end.plugin-disable", new Object[0]);
                    this.handleWin(winner, arena.getOpponent(winner), arena, match);
                }
            } else {
                boolean ongoing = size > 1;
                for (Player player : match.getAllPlayers()) {
                    this.lang.sendMessage((CommandSender)player, "DUEL.on-end.plugin-disable", new Object[0]);
                    this.handleTie(player, arena, match, ongoing);
                }
            }
            arena.endMatch(null, null, MatchEndEvent.Reason.PLUGIN_DISABLE);
        }
    }

    private void handleTie(Player player, ArenaImpl arena, DuelMatch match, boolean alive) {
        arena.remove(player);
        if (this.vault != null && match.getBet() > 0) {
            this.vault.add(match.getBet(), player);
        }
        if (this.mcMMO != null) {
            this.mcMMO.enableSkills(player);
        }
        PlayerInfo info = this.playerManager.get(player);
        List<ItemStack> items = match.getItems(player);
        if (alive) {
            this.playerManager.remove(player);
            if (!match.isOwnInventory() || !this.config.isOwnInventoryDropInventoryItems()) {
                PlayerUtil.reset(player);
            }
            if (info != null) {
                this.teleport.tryTeleport(player, info.getLocation());
                info.restore(player);
            } else {
                this.teleport.tryTeleport(player, this.playerManager.getLobby());
            }
            InventoryUtil.addOrDrop(player, items);
        } else if (info != null) {
            info.getExtra().addAll(items);
        } else {
            InventoryUtil.addOrDrop(player, items);
        }
    }

    private void handleWin(Player winner, Player opponent, ArenaImpl arena, DuelMatch match) {
        String opponentName;
        arena.remove(winner);
        String string = opponentName = opponent != null ? opponent.getName() : this.lang.getMessage("GENERAL.none");
        if (this.vault != null && match.getBet() > 0) {
            int amount = match.getBet() * 2;
            this.vault.add(amount, winner);
            this.lang.sendMessage((CommandSender)winner, "DUEL.reward.money.message", "name", opponentName, "money", amount);
            String title = this.lang.getMessage("DUEL.reward.money.title", "name", opponentName, "money", amount);
            if (title != null) {
                Titles.send(winner, title, null, 0, 20, 50);
            }
        }
        if (this.mcMMO != null) {
            this.mcMMO.enableSkills(winner);
        }
        PlayerInfo info = this.playerManager.get(winner);
        List<ItemStack> items = match.getItems();
        if (!winner.isDead()) {
            this.playerManager.remove(winner);
            if (!match.isOwnInventory() || !this.config.isOwnInventoryDropInventoryItems()) {
                PlayerUtil.reset(winner);
            }
            if (info != null) {
                this.teleport.tryTeleport(winner, info.getLocation());
                info.restore(winner);
            }
            if (InventoryUtil.addOrDrop(winner, items)) {
                this.lang.sendMessage((CommandSender)winner, "DUEL.reward.items.message", "name", opponentName);
            }
        } else if (info != null) {
            info.getExtra().addAll(items);
        }
    }

    private void refundItems(Collection<Player> players, Map<UUID, List<ItemStack>> items) {
        if (items != null) {
            players.forEach(player -> InventoryUtil.addOrDrop(player, items.getOrDefault(player.getUniqueId(), Collections.emptyList())));
        }
    }

    public boolean startMatch(Collection<Player> first, Collection<Player> second, Settings settings, Map<UUID, List<ItemStack>> items, Queue source) {
        ArenaImpl arena;
        ArrayList<Player> players = new ArrayList<Player>(first.size() + second.size());
        players.addAll(first);
        players.addAll(second);
        if (!ValidatorUtil.validate(this.plugin.getValidatorManager().getMatchValidators(), players, settings)) {
            this.refundItems(players, items);
            return false;
        }
        KitImpl kit = settings.getKit();
        ArenaImpl arenaImpl = arena = settings.getArena() != null ? settings.getArena() : this.arenaManager.randomArena(kit);
        if (arena == null || !arena.isAvailable()) {
            this.lang.sendMessage(players, "DUEL.start-failure." + (settings.getArena() != null ? "arena-in-use" : "no-arena-available"), new Object[0]);
            this.refundItems(players, items);
            return false;
        }
        if (kit != null && !this.arenaManager.isSelectable(kit, arena)) {
            this.lang.sendMessage(players, "DUEL.start-failure.arena-not-applicable", "kit", kit.getName(), "arena", arena.getName());
            this.refundItems(players, items);
            return false;
        }
        int bet = settings.getBet();
        if (bet > 0 && this.vault != null) {
            if (!this.vault.has(bet, players)) {
                this.lang.sendMessage(players, "DUEL.start-failure.not-enough-money", "bet_amount", bet);
                this.refundItems(players, items);
                return false;
            }
            this.vault.remove(bet, players);
        }
        DuelMatch match = arena.startMatch(kit, items, settings, source);
        this.addPlayers(first, match, arena, kit, arena.getPosition(1));
        this.addPlayers(second, match, arena, kit, arena.getPosition(2));
        if (this.config.isCdEnabled()) {
            arena.startCountdown();
        }
        MatchStartEvent event = new MatchStartEvent(match, players.toArray(new Player[players.size()]));
        Bukkit.getPluginManager().callEvent((Event)event);
        return true;
    }

    public boolean startMatch(Player sender, Player target, Settings settings, Map<UUID, List<ItemStack>> items, Queue source) {
        Party senderParty = this.partyManager.get(sender);
        Party targetParty = this.partyManager.get(target);
        if (senderParty != null && targetParty != null) {
            if (!settings.getSenderParty().equals(senderParty) || !settings.getTargetParty().equals(targetParty)) {
                this.lang.sendMessage(Arrays.asList(sender, target), "DUEL.party-start-failure.party-changed", new Object[0]);
                return false;
            }
            return this.startMatch(settings.getSenderParty().getOnlineMembers(), settings.getTargetParty().getOnlineMembers(), settings, items, source);
        }
        if (senderParty != null || targetParty != null) {
            this.lang.sendMessage(Arrays.asList(sender, target), "DUEL.party-start-failure.party-changed", new Object[0]);
            return false;
        }
        return this.startMatch(Collections.singleton(sender), Collections.singleton(target), settings, items, source);
    }

    private void addPlayers(Collection<Player> players, DuelMatch match, ArenaImpl arena, KitImpl kit, Location location) {
        for (Player player : players) {
            if (match.getSource() == null) {
                this.queueManager.remove(player);
            }
            if (player.getAllowFlight()) {
                player.setFlying(false);
                player.setAllowFlight(false);
            }
            player.closeInventory();
            boolean dropOwnInv = match.isOwnInventory() && this.config.isOwnInventoryDropInventoryItems();
            boolean restoreExperience = !match.isOwnInventory();
            this.playerManager.create(player, dropOwnInv, restoreExperience);
            this.teleport.tryTeleport(player, location);
            if (kit != null) {
                PlayerUtil.reset(player);
                kit.equip(player);
            }
            if (this.config.isStartCommandsEnabled() && (match.getSource() != null || !this.config.isStartCommandsQueueOnly())) {
                try {
                    for (String command : this.config.getStartCommands()) {
                        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replace("%player%", player.getName()));
                    }
                }
                catch (Exception ex) {
                    Log.warn(this, "Error while running match start commands: " + ex.getMessage());
                }
            }
            if (this.myPet != null) {
                this.myPet.removePet(player);
            }
            if (this.essentials != null) {
                this.essentials.tryUnvanish(player);
            }
            if (this.mcMMO != null) {
                this.mcMMO.disableSkills(player);
            }
            arena.add(player);
        }
    }

    private class DuelListener
    implements Listener {
        private DuelListener() {
        }

        @EventHandler(priority=EventPriority.HIGHEST)
        public void on(PlayerDeathEvent event) {
            DuelMatch match;
            Player player = event.getEntity();
            ArenaImpl arena = DuelManager.this.arenaManager.get(player);
            if (arena == null) {
                return;
            }
            if (DuelManager.this.mcMMO != null) {
                DuelManager.this.mcMMO.enableSkills(player);
            }
            if ((match = arena.getMatch()) == null) {
                return;
            }
            if (match.getKit() != null && match.getKit().hasCharacteristic(KitImpl.Characteristic.ROUNDS3)) {
                event.setDeathMessage(null);
                event.getDrops().clear();
                event.setKeepLevel(true);
                event.setDroppedExp(0);
                event.setKeepInventory(true);
                return;
            }
            Inventory top = player.getOpenInventory().getTopInventory();
            if (top.getType() == InventoryType.CRAFTING) {
                top.clear();
            }
            if (!match.isOwnInventory() || !DuelManager.this.config.isOwnInventoryDropInventoryItems()) {
                event.getDrops().clear();
                event.setKeepLevel(true);
                event.setDroppedExp(0);
                event.setKeepInventory(false);
            }
            DuelManager.this.inventoryManager.create(player, true);
            if (DuelManager.this.config.isSendDeathMessages()) {
                Player killer = player.getKiller();
                if (killer != null) {
                    double health = Math.ceil(killer.getHealth()) * 0.5;
                    arena.broadcast(DuelManager.this.lang.getMessage("DUEL.on-death.with-killer", "name", player.getName(), "killer", killer.getName(), "health", health));
                } else {
                    arena.broadcast(DuelManager.this.lang.getMessage("DUEL.on-death.no-killer", "name", player.getName()));
                }
            }
            int prevSize = match.size();
            arena.remove(player);
            if (prevSize < 2 || match.size() >= prevSize) {
                return;
            }
            Location deadLocation = player.getEyeLocation().clone();
            DuelManager.this.handleMatchEnd(match, arena, player, deadLocation, match.getAlivePlayers().iterator().next());
        }

        @EventHandler(ignoreCancelled=true)
        public void on(EntityDamageEvent event) {
            if (!(event.getEntity() instanceof Player)) {
                return;
            }
            Player player = (Player)event.getEntity();
            ArenaImpl arena = DuelManager.this.arenaManager.get(player);
            if (arena == null || !arena.isEndGame()) {
                return;
            }
            event.setCancelled(true);
        }

        @EventHandler
        public void on(PlayerInteractEvent event) {
            if (!DuelManager.this.config.isDisableEnderpearlInEndgame()) {
                return;
            }
            Player player = event.getPlayer();
            ArenaImpl arena = DuelManager.this.arenaManager.get(player);
            if (arena == null || !arena.isEndGame()) {
                return;
            }
            event.setCancelled(true);
        }

        @EventHandler
        public void on(PlayerMoveEvent event) {
            if (!DuelManager.this.config.isDisableMovementInEndgame()) {
                return;
            }
            Player player = event.getPlayer();
            ArenaImpl arena = DuelManager.this.arenaManager.get(player);
            if (arena == null || !arena.isEndGame()) {
                return;
            }
            event.setCancelled(true);
        }

        @EventHandler
        public void on(PlayerQuitEvent event) {
            Player player = event.getPlayer();
            if (!DuelManager.this.arenaManager.isInMatch(player)) {
                return;
            }
            player.setHealth(0.0);
            player.spigot().respawn();
        }

        @EventHandler(ignoreCancelled=true)
        public void on(PlayerDropItemEvent event) {
            Player player = event.getPlayer();
            if (!DuelManager.this.arenaManager.isInMatch(event.getPlayer())) {
                return;
            }
            if (DuelManager.this.config.isPreventItemDrop()) {
                event.setCancelled(true);
                DuelManager.this.lang.sendMessage((CommandSender)event.getPlayer(), "DUEL.prevent.item-drop", new Object[0]);
            } else if (DuelManager.this.config.isClearItemsAfterMatch()) {
                DuelManager.this.arenaManager.get((Player)player).getMatch().droppedItems.add(event.getItemDrop());
            }
        }

        @EventHandler(ignoreCancelled=true)
        public void on(PlayerPickupItemEvent event) {
            if (!CompatUtil.isPre1_13() && event.getItem().getItemStack().getType() == Material.TRIDENT) {
                return;
            }
            if (!DuelManager.this.config.isPreventItemPickup() || !DuelManager.this.arenaManager.isInMatch(event.getPlayer())) {
                return;
            }
            event.setCancelled(true);
        }

        @EventHandler(ignoreCancelled=true)
        public void on(PlayerCommandPreprocessEvent event) {
            String command = event.getMessage().substring(1).split(" ")[0].toLowerCase();
            if (!DuelManager.this.arenaManager.isInMatch(event.getPlayer()) || (DuelManager.this.config.isBlockAllCommands() ? DuelManager.this.config.getWhitelistedCommands().contains(command) : !DuelManager.this.config.getBlacklistedCommands().contains(command))) {
                return;
            }
            event.setCancelled(true);
            DuelManager.this.lang.sendMessage((CommandSender)event.getPlayer(), "DUEL.prevent.command", "command", event.getMessage());
        }

        @EventHandler(ignoreCancelled=true)
        public void on(PlayerTeleportEvent event) {
            Player player = event.getPlayer();
            Location to = event.getTo();
            if (!DuelManager.this.config.isLimitTeleportEnabled() || event.getCause() == PlayerTeleportEvent.TeleportCause.ENDER_PEARL || event.getCause() == PlayerTeleportEvent.TeleportCause.SPECTATE || !DuelManager.this.arenaManager.isInMatch(player)) {
                return;
            }
            Location from = event.getFrom();
            if (from.getWorld().equals((Object)to.getWorld()) && from.distance(to) <= DuelManager.this.config.getDistanceAllowed()) {
                return;
            }
            event.setCancelled(true);
            DuelManager.this.lang.sendMessage((CommandSender)player, "DUEL.prevent.teleportation", new Object[0]);
        }

        @EventHandler(ignoreCancelled=true)
        public void on(InventoryOpenEvent event) {
            if (!DuelManager.this.config.isPreventInventoryOpen()) {
                return;
            }
            Player player = (Player)event.getPlayer();
            if (!DuelManager.this.arenaManager.isInMatch(player)) {
                return;
            }
            event.setCancelled(true);
            DuelManager.this.lang.sendMessage((CommandSender)player, "DUEL.prevent.inventory-open", new Object[0]);
        }
    }
}

