/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.gui.settings.buttons;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.gui.BaseButton;
import com.meteordevelopments.duels.setting.Settings;
import com.meteordevelopments.duels.util.inventory.ItemBuilder;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ItemBettingButton
extends BaseButton {
    public ItemBettingButton(DuelsPlugin plugin) {
        super(plugin, ItemBuilder.of(Material.DIAMOND).name(plugin.getLang().getMessage("GUI.settings.buttons.item-betting.name")).build());
    }

    @Override
    public void update(Player player) {
        if (this.config.isItemBettingUsePermission() && !player.hasPermission("duels.use.item-betting") && !player.hasPermission("duels.use.*")) {
            this.setLore(this.lang.getMessage("GUI.settings.buttons.item-betting.lore-no-permission").split("\n"));
            return;
        }
        Settings settings = this.settingManager.getSafely(player);
        String itemBetting = settings.isItemBetting() ? this.lang.getMessage("GENERAL.enabled") : this.lang.getMessage("GENERAL.disabled");
        String lore = ((DuelsPlugin)this.plugin).getLang().getMessage("GUI.settings.buttons.item-betting.lore", "item_betting", itemBetting);
        this.setLore(lore.split("\n"));
    }

    @Override
    public void onClick(Player player) {
        if (this.config.isItemBettingUsePermission() && !player.hasPermission("duels.use.item-betting") && !player.hasPermission("duels.use.*")) {
            this.lang.sendMessage((CommandSender)player, "ERROR.no-permission", "permission", "duels.use.item-betting");
            return;
        }
        Settings settings = this.settingManager.getSafely(player);
        if (settings.isPartyDuel()) {
            this.lang.sendMessage((CommandSender)player, "ERROR.party-duel.option-unavailable", new Object[0]);
            return;
        }
        settings.setItemBetting(!settings.isItemBetting());
        settings.updateGui(player);
    }
}

