/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.gui.settings.buttons;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.gui.BaseButton;
import com.meteordevelopments.duels.setting.Settings;
import com.meteordevelopments.duels.util.inventory.ItemBuilder;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class OwnInventoryButton
extends BaseButton {
    public OwnInventoryButton(DuelsPlugin plugin) {
        super(plugin, ItemBuilder.of(Material.getMaterial((String)plugin.getLang().getMessage("GUI.settings.buttons.use-own-inventory.material").toUpperCase())).name(plugin.getLang().getMessage("GUI.settings.buttons.use-own-inventory.name")).build());
    }

    @Override
    public void update(Player player) {
        if (this.config.isOwnInventoryUsePermission() && !player.hasPermission("duels.use.own-inventory") && !player.hasPermission("duels.use.*")) {
            this.setLore(this.lang.getMessage("GUI.settings.buttons.use-own-inventory.lore-no-permission").split("\n"));
            return;
        }
        Settings settings = this.settingManager.getSafely(player);
        String ownInventory = settings.isOwnInventory() ? this.lang.getMessage("GENERAL.enabled") : this.lang.getMessage("GENERAL.disabled");
        String lore = ((DuelsPlugin)this.plugin).getLang().getMessage("GUI.settings.buttons.use-own-inventory.lore", "own_inventory", ownInventory);
        this.setLore(lore.split("\n"));
    }

    @Override
    public void onClick(Player player) {
        Settings settings;
        if (this.config.isOwnInventoryUsePermission() && !player.hasPermission("duels.use.own-inventory") && !player.hasPermission("duels.use.*")) {
            this.lang.sendMessage((CommandSender)player, "ERROR.no-permission", "permission", "duels.use.own-inventory");
            return;
        }
        if (!this.config.isKitSelectingEnabled()) {
            this.lang.sendMessage((CommandSender)player, "ERROR.duel.mode-fixed", new Object[0]);
            return;
        }
        settings.setOwnInventory(!(settings = this.settingManager.getSafely(player)).isOwnInventory());
        settings.updateGui(player);
    }
}

