/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.hook.hooks;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.arena.ArenaManagerImpl;
import com.meteordevelopments.duels.config.Config;
import com.meteordevelopments.duels.util.hook.PluginHook;
import me.NoChance.PvPManager.Events.PlayerTagEvent;
import me.NoChance.PvPManager.Managers.PlayerHandler;
import me.NoChance.PvPManager.PvPManager;
import me.NoChance.PvPManager.PvPlayer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class PvPManagerHook
extends PluginHook<DuelsPlugin> {
    public static final String NAME = "PvPManager";
    private final Config config;
    private final ArenaManagerImpl arenaManager;

    public PvPManagerHook(DuelsPlugin plugin) {
        super(plugin, NAME);
        this.config = plugin.getConfiguration();
        this.arenaManager = plugin.getArenaManager();
        try {
            Class.forName("me.NoChance.PvPManager.Events.PlayerTagEvent");
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("This version of " + this.getName() + " is not supported. Please try upgrading to the latest version.");
        }
        Bukkit.getPluginManager().registerEvents((Listener)new PvPManagerListener(), (Plugin)plugin);
    }

    public boolean isTagged(Player player) {
        if (this.config.isPmPreventDuel()) {
            return false;
        }
        PlayerHandler playerHandler = ((PvPManager)this.getPlugin()).getPlayerHandler();
        if (playerHandler == null) {
            return false;
        }
        PvPlayer pvPlayer = playerHandler.get(player);
        return pvPlayer != null && pvPlayer.isInCombat();
    }

    public class PvPManagerListener
    implements Listener {
        @EventHandler(ignoreCancelled=true)
        public void on(PlayerTagEvent event) {
            if (!PvPManagerHook.this.config.isPmPreventTag()) {
                return;
            }
            Player player = event.getPlayer();
            if (!PvPManagerHook.this.arenaManager.isInMatch(player)) {
                return;
            }
            event.setCancelled(true);
        }
    }
}

