/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.match.party;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.arena.ArenaImpl;
import com.meteordevelopments.duels.kit.KitImpl;
import com.meteordevelopments.duels.match.DuelMatch;
import com.meteordevelopments.duels.party.Party;
import com.meteordevelopments.duels.queue.Queue;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PartyDuelMatch
extends DuelMatch {
    private final Map<Player, Party> playerToParty = new HashMap<Player, Party>();
    private final Multimap<Party, Player> partyToPlayers = HashMultimap.create();
    private final Map<Party, Integer> alivePlayers = new HashMap<Party, Integer>();

    public PartyDuelMatch(DuelsPlugin plugin, ArenaImpl arena, KitImpl kit, Map<UUID, List<ItemStack>> items, int bet, Queue source) {
        super(plugin, arena, kit, items, bet, source);
    }

    public Set<Party> getAllParties() {
        return this.partyToPlayers.keySet();
    }

    public List<String> getNames(Party party) {
        Collection members = (Collection)this.partyToPlayers.asMap().get(party);
        if (members == null) {
            return Collections.emptyList();
        }
        return members.stream().map(Player::getName).collect(Collectors.toList());
    }

    @Override
    public void addPlayer(Player player) {
        super.addPlayer(player);
        Party party = this.partyManager.get(player);
        this.playerToParty.put(player, party);
        this.partyToPlayers.put((Object)party, (Object)player);
        Integer count = this.alivePlayers.get(party);
        if (count == null) {
            this.alivePlayers.put(party, 1);
            return;
        }
        this.alivePlayers.put(party, count + 1);
    }

    @Override
    public void markAsDead(Player player) {
        super.markAsDead(player);
        Party party = this.playerToParty.get(player);
        if (party == null) {
            return;
        }
        Integer count = this.alivePlayers.get(party);
        if (count == null) {
            return;
        }
        this.alivePlayers.put(party, count - 1);
    }

    @Override
    public int size() {
        return (int)this.alivePlayers.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).count();
    }

    @Generated
    public Map<Player, Party> getPlayerToParty() {
        return this.playerToParty;
    }

    @Generated
    public Multimap<Party, Player> getPartyToPlayers() {
        return this.partyToPlayers;
    }
}

