/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.party;

import com.meteordevelopments.duels-optimised.shaded.morepaperlib.scheduling.ScheduledTask;
import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.config.Config;
import com.meteordevelopments.duels.config.Lang;
import com.meteordevelopments.duels.party.Party;
import com.meteordevelopments.duels.party.PartyInvite;
import com.meteordevelopments.duels.party.PartyMember;
import com.meteordevelopments.duels.util.EventUtil;
import com.meteordevelopments.duels.util.Loadable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class PartyManagerImpl
implements Loadable,
Listener {
    private final DuelsPlugin plugin;
    private final Config config;
    private final Lang lang;
    private final Map<UUID, Map<UUID, PartyInvite>> invites = new HashMap<UUID, Map<UUID, PartyInvite>>();
    private final Map<UUID, Party> partyMap = new HashMap<UUID, Party>();
    private final List<Party> parties = new ArrayList<Party>();
    private ScheduledTask autoDisbandTask;

    public PartyManagerImpl(DuelsPlugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfiguration();
        this.lang = plugin.getLang();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public void handleLoad() {
        if (this.config.getPartyAutoDisbandAfter() > 0) {
            this.autoDisbandTask = this.plugin.doSyncRepeat(() -> {
                Iterator<Party> iterator = this.parties.iterator();
                while (iterator.hasNext()) {
                    Party party = iterator.next();
                    if (party.getOwner().isOnline() || System.currentTimeMillis() - party.getOwner().getLastLogout() < (long)(this.config.getPartyAutoDisbandAfter() * 60) * 1000L) continue;
                    this.lang.sendMessage(party.getOnlineMembers(), "PARTY.auto-disband", new Object[0]);
                    party.setRemoved(true);
                    party.getMembers().forEach(member -> this.partyMap.remove(member.getUuid()));
                    iterator.remove();
                }
            }, 0L, 1200L);
        }
    }

    @Override
    public void handleUnload() {
        this.plugin.cancelTask(this.autoDisbandTask);
        this.invites.clear();
        this.parties.clear();
        this.partyMap.clear();
    }

    private Map<UUID, PartyInvite> getInvites(Player player, boolean create) {
        Map<UUID, PartyInvite> cached = this.invites.get(player.getUniqueId());
        if (cached == null && create) {
            cached = new HashMap<UUID, PartyInvite>();
            this.invites.put(player.getUniqueId(), cached);
            return cached;
        }
        return cached;
    }

    public PartyInvite getInvite(Player sender, Player target) {
        Map<UUID, PartyInvite> cached = this.getInvites(sender, false);
        if (cached == null) {
            return null;
        }
        PartyInvite invite = cached.get(target.getUniqueId());
        if (invite == null) {
            return null;
        }
        if (System.currentTimeMillis() - invite.getCreation() >= (long)this.config.getPartyInviteExpiration() * 1000L) {
            cached.remove(target.getUniqueId());
            return null;
        }
        return invite;
    }

    public boolean hasInvite(Player sender, Player target) {
        return this.getInvite(sender, target) != null;
    }

    public PartyInvite removeInvite(Player sender, Player target) {
        Map<UUID, PartyInvite> cached = this.getInvites(sender, false);
        if (cached == null) {
            return null;
        }
        PartyInvite invite = cached.remove(target.getUniqueId());
        if (invite == null) {
            return null;
        }
        if (System.currentTimeMillis() - invite.getCreation() >= (long)this.config.getPartyInviteExpiration() * 1000L) {
            cached.remove(target.getUniqueId());
            return null;
        }
        return invite;
    }

    public boolean sendInvite(Player sender, Player target, Party party) {
        if (party.size() >= this.config.getPartyMaxSize()) {
            return false;
        }
        PartyInvite invite = new PartyInvite(sender, target, party);
        this.getInvites(sender, true).put(target.getUniqueId(), invite);
        return true;
    }

    public Party get(Player player) {
        return this.partyMap.get(player.getUniqueId());
    }

    public Party getOrCreate(Player player) {
        Party party = this.get(player);
        if (party != null) {
            return party;
        }
        party = new Party(player);
        this.parties.add(party);
        this.partyMap.put(player.getUniqueId(), party);
        return party;
    }

    public boolean isInParty(Player player) {
        return this.get(player) != null;
    }

    public boolean canDamage(Player damager, Player damaged) {
        Party party = this.get(damager);
        if (party == null || !party.equals(this.get(damaged))) {
            return true;
        }
        return party.isFriendlyFire();
    }

    public boolean join(Player player, Party party) {
        if (party.size() >= this.config.getPartyMaxSize()) {
            return false;
        }
        party.add(player);
        this.partyMap.put(player.getUniqueId(), party);
        return true;
    }

    public void remove(Player player, Party party) {
        party.remove(player);
        this.partyMap.remove(player.getUniqueId());
    }

    public void remove(PartyMember member, Party party) {
        party.remove(member);
        this.partyMap.remove(member.getUuid());
    }

    public void remove(Party party) {
        party.setRemoved(true);
        party.getMembers().forEach(member -> this.partyMap.remove(member.getUuid()));
        this.parties.remove(party);
    }

    @EventHandler
    public void on(EntityDamageByEntityEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player damaged = (Player)event.getEntity();
        Player damager = EventUtil.getDamager(event);
        if (damager == null || this.canDamage(damager, damaged)) {
            return;
        }
        event.setCancelled(true);
        this.lang.sendMessage((CommandSender)damager, "ERROR.party.cannot-friendly-fire", "name", damaged.getName());
    }

    @EventHandler
    public void on(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.invites.remove(player.getUniqueId());
        Party party = this.get(player);
        if (party == null) {
            return;
        }
        party.get(player).setLastLogout();
    }
}

