/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.queue;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.api.kit.Kit;
import com.meteordevelopments.duels.api.queue.DQueue;
import com.meteordevelopments.duels.gui.BaseButton;
import com.meteordevelopments.duels.queue.QueueEntry;
import com.meteordevelopments.duels.util.inventory.ItemBuilder;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class Queue
extends BaseButton
implements DQueue {
    private final Kit kit;
    private final int bet;
    private final List<QueueEntry> players = new LinkedList<QueueEntry>();
    private boolean removed;

    public Queue(DuelsPlugin plugin, Kit kit, int bet) {
        super(plugin, ItemBuilder.of(plugin.getConfiguration().isInheritKitItemType() && kit != null ? kit.getDisplayed().clone() : ItemBuilder.of(Material.DIAMOND_SWORD).build()).name(plugin.getLang().getMessage("GUI.queues.buttons.queue.name", "kit", kit != null ? kit.getName() : plugin.getLang().getMessage("GENERAL.none"), "bet_amount", bet, "in_queue", 0, "in_match", 0)).lore(plugin.getLang().getMessage("GUI.queues.buttons.queue.lore", "kit", kit != null ? kit.getName() : plugin.getLang().getMessage("GENERAL.none"), "bet_amount", bet, "in_queue", 0, "in_match", 0).split("\n")).build());
        this.kit = kit;
        this.bet = bet;
    }

    @Override
    public boolean isInQueue(@NotNull Player player) {
        return this.players.stream().anyMatch(entry -> entry.getPlayer().equals((Object)player));
    }

    @Override
    @NotNull
    public List<Player> getQueuedPlayers() {
        return Collections.unmodifiableList(((Stream)this.players.stream().sequential()).map(QueueEntry::getPlayer).collect(Collectors.toList()));
    }

    void addPlayer(QueueEntry entry) {
        this.players.add(entry);
        this.update();
        this.queueManager.getGui().calculatePages();
    }

    boolean removePlayer(Player player) {
        if (this.players.removeIf(entry -> entry.getPlayer().equals((Object)player))) {
            this.update();
            this.queueManager.getGui().calculatePages();
            return true;
        }
        return false;
    }

    boolean removeAll(Set<QueueEntry> players) {
        if (this.players.removeAll(players)) {
            this.update();
            return true;
        }
        return false;
    }

    @Override
    public long getPlayersInMatch() {
        return this.arenaManager.getPlayersInMatch(this);
    }

    public void update() {
        int inQueue = this.players.size();
        long inMatch = this.getPlayersInMatch();
        this.setDisplayName(this.lang.getMessage("GUI.queues.buttons.queue.name", "kit", this.kit != null ? this.kit.getName() : this.lang.getMessage("GENERAL.none"), "bet_amount", this.bet, "in_queue", inQueue, "in_match", inMatch));
        this.setLore(this.lang.getMessage("GUI.queues.buttons.queue.lore", "kit", this.kit != null ? this.kit.getName() : this.lang.getMessage("GENERAL.none"), "bet_amount", this.bet, "in_queue", inQueue, "in_match", inMatch).split("\n"));
    }

    @Override
    public void onClick(Player player) {
        this.queueManager.addToQueue(player, this);
    }

    public String toString() {
        return (this.kit != null ? this.kit.getName() : "none") + " ($" + this.bet + ")";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Queue queue = (Queue)other;
        return this.bet == queue.bet && Objects.equals(this.kit, queue.kit);
    }

    public int hashCode() {
        return Objects.hash(this.kit, this.bet);
    }

    @Override
    @Generated
    public Kit getKit() {
        return this.kit;
    }

    @Override
    @Generated
    public int getBet() {
        return this.bet;
    }

    @Generated
    public List<QueueEntry> getPlayers() {
        return this.players;
    }

    @Override
    @Generated
    public boolean isRemoved() {
        return this.removed;
    }

    @Generated
    void setRemoved(boolean removed) {
        this.removed = removed;
    }
}

