/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.queue.sign;

import com.meteordevelopments.duels.api.queue.sign.QueueSign;
import com.meteordevelopments.duels.queue.Queue;
import com.meteordevelopments.duels.util.StringUtil;
import java.util.Objects;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;

public class QueueSignImpl
implements QueueSign {
    private final Location location;
    private final String[] lines;
    private final Queue queue;
    private boolean removed;
    private int lastInQueue;
    private long lastInMatch;

    public QueueSignImpl(Location location, String format, Queue queue) {
        this.location = location;
        this.queue = queue;
        String[] data = new String[]{"", "", "", ""};
        if (format != null) {
            String[] lines = format.split("\n");
            System.arraycopy(lines, 0, data, 0, lines.length);
        }
        this.lines = data;
        Block block = location.getBlock();
        if (!(block.getState() instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)block.getState();
        sign.setLine(0, this.replace(this.lines[0], 0, 0L));
        sign.setLine(1, this.replace(this.lines[1], 0, 0L));
        sign.setLine(2, this.replace(this.lines[2], 0, 0L));
        sign.setLine(3, this.replace(this.lines[3], 0, 0L));
        sign.update();
    }

    private String replace(String line, int inQueue, long inMatch) {
        return StringUtil.color(line.replace("%in_queue%", String.valueOf(inQueue)).replace("%in_match%", String.valueOf(inMatch)));
    }

    public void update() {
        Block block = this.location.getBlock();
        if (!(block.getState() instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)block.getState();
        if (this.queue.isRemoved()) {
            sign.setType(Material.AIR);
            sign.update();
            return;
        }
        int inQueue = this.queue.getPlayers().size();
        long inMatch = this.queue.getPlayersInMatch();
        if (this.lastInQueue == inQueue && this.lastInMatch == inMatch) {
            return;
        }
        this.lastInQueue = inQueue;
        this.lastInMatch = inMatch;
        sign.setLine(0, this.replace(this.lines[0], inQueue, inMatch));
        sign.setLine(1, this.replace(this.lines[1], inQueue, inMatch));
        sign.setLine(2, this.replace(this.lines[2], inQueue, inMatch));
        sign.setLine(3, this.replace(this.lines[3], inQueue, inMatch));
        sign.update();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueueSignImpl queueSign = (QueueSignImpl)o;
        return Objects.equals(this.queue, queueSign.getQueue());
    }

    public int hashCode() {
        return Objects.hash(this.queue);
    }

    public String toString() {
        return StringUtil.parse(this.location);
    }

    @Override
    @Generated
    public Location getLocation() {
        return this.location;
    }

    @Generated
    public String[] getLines() {
        return this.lines;
    }

    @Override
    @Generated
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    @Generated
    public boolean isRemoved() {
        return this.removed;
    }

    @Generated
    void setRemoved(boolean removed) {
        this.removed = removed;
    }
}

