/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.shaded.jackson.databind.deser.impl;

import com.meteordevelopments.duels.shaded.jackson.core.JsonParser;
import com.meteordevelopments.duels.shaded.jackson.databind.DeserializationContext;
import com.meteordevelopments.duels.shaded.jackson.databind.deser.SettableAnyProperty;
import com.meteordevelopments.duels.shaded.jackson.databind.deser.SettableBeanProperty;
import com.meteordevelopments.duels.shaded.jackson.databind.util.TokenBuffer;
import java.io.IOException;

public abstract class PropertyValue {
    public final PropertyValue next;
    public final Object value;

    protected PropertyValue(PropertyValue next, Object value) {
        this.next = next;
        this.value = value;
    }

    @Deprecated
    public final void assign(Object bean) throws IOException {
        this.assign(null, bean);
    }

    public void assign(DeserializationContext ctxt, Object bean) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void setValue(Object parameterObject) throws IOException {
        throw new UnsupportedOperationException("Should not be called on type: " + this.getClass().getName());
    }

    static final class Merging
    extends PropertyValue {
        final SettableBeanProperty _property;

        public Merging(PropertyValue next, TokenBuffer buffered, SettableBeanProperty prop) {
            super(next, buffered);
            this._property = prop;
        }

        @Override
        public void assign(DeserializationContext ctxt, Object bean) throws IOException {
            TokenBuffer buffered = (TokenBuffer)this.value;
            try (JsonParser p = buffered.asParser();){
                p.nextToken();
                this._property.deserializeAndSet(p, ctxt, bean);
            }
        }
    }

    static final class AnyParameter
    extends PropertyValue {
        final SettableAnyProperty _property;
        final String _propertyName;

        public AnyParameter(PropertyValue next, Object value, SettableAnyProperty prop, String propName) {
            super(next, value);
            this._property = prop;
            this._propertyName = propName;
        }

        @Override
        public void assign(DeserializationContext ctxt, Object bean) throws IOException {
        }

        @Override
        public void setValue(Object parameterObject) throws IOException {
            this._property.set(parameterObject, this._propertyName, this.value);
        }
    }

    static final class Map
    extends PropertyValue {
        final Object _key;

        public Map(PropertyValue next, Object value, Object key) {
            super(next, value);
            this._key = key;
        }

        @Override
        public void assign(DeserializationContext ctxt, Object bean) throws IOException {
            ((java.util.Map)bean).put(this._key, this.value);
        }
    }

    static final class Any
    extends PropertyValue {
        final SettableAnyProperty _property;
        final String _propertyName;

        public Any(PropertyValue next, Object value, SettableAnyProperty prop, String propName) {
            super(next, value);
            this._property = prop;
            this._propertyName = propName;
        }

        @Override
        public void assign(DeserializationContext ctxt, Object bean) throws IOException {
            this._property.set(bean, this._propertyName, this.value);
        }
    }

    static final class Regular
    extends PropertyValue {
        final SettableBeanProperty _property;

        public Regular(PropertyValue next, Object value, SettableBeanProperty prop) {
            super(next, value);
            this._property = prop;
        }

        @Override
        public void assign(DeserializationContext ctxt, Object bean) throws IOException {
            this._property.set(bean, this.value);
        }
    }
}

