/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.spectate;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.api.arena.Arena;
import com.meteordevelopments.duels.api.event.spectate.SpectateEndEvent;
import com.meteordevelopments.duels.api.event.spectate.SpectateStartEvent;
import com.meteordevelopments.duels.api.spectate.SpectateManager;
import com.meteordevelopments.duels.api.spectate.Spectator;
import com.meteordevelopments.duels.arena.ArenaImpl;
import com.meteordevelopments.duels.arena.ArenaManagerImpl;
import com.meteordevelopments.duels.config.Config;
import com.meteordevelopments.duels.config.Lang;
import com.meteordevelopments.duels.hook.hooks.EssentialsHook;
import com.meteordevelopments.duels.hook.hooks.MyPetHook;
import com.meteordevelopments.duels.match.DuelMatch;
import com.meteordevelopments.duels.player.PlayerInfo;
import com.meteordevelopments.duels.player.PlayerInfoManager;
import com.meteordevelopments.duels.spectate.SpectatorImpl;
import com.meteordevelopments.duels.teleport.Teleport;
import com.meteordevelopments.duels.util.BlockUtil;
import com.meteordevelopments.duels.util.EventUtil;
import com.meteordevelopments.duels.util.Loadable;
import com.meteordevelopments.duels.util.PlayerUtil;
import com.meteordevelopments.duels.util.compat.CompatUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockCanBuildEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpectateManagerImpl
implements Loadable,
SpectateManager {
    private final DuelsPlugin plugin;
    private final Config config;
    private final Lang lang;
    private final ArenaManagerImpl arenaManager;
    private final PlayerInfoManager playerManager;
    private final Map<UUID, SpectatorImpl> spectators = new HashMap<UUID, SpectatorImpl>();
    private final Multimap<Arena, SpectatorImpl> arenas = HashMultimap.create();
    private Teleport teleport;
    private MyPetHook myPet;
    private EssentialsHook essentials;

    public SpectateManagerImpl(DuelsPlugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfiguration();
        this.lang = plugin.getLang();
        this.arenaManager = plugin.getArenaManager();
        this.playerManager = plugin.getPlayerManager();
        Bukkit.getPluginManager().registerEvents((Listener)new SpectateListener(), (Plugin)plugin);
    }

    @Override
    public void handleLoad() {
        this.teleport = this.plugin.getTeleport();
        this.myPet = this.plugin.getHookManager().getHook(MyPetHook.class);
        this.essentials = this.plugin.getHookManager().getHook(EssentialsHook.class);
    }

    @Override
    public void handleUnload() {
        this.spectators.clear();
    }

    @Override
    @Nullable
    public SpectatorImpl get(@NotNull Player player) {
        Objects.requireNonNull(player, "player");
        return this.spectators.get(player.getUniqueId());
    }

    @Override
    public boolean isSpectating(@NotNull Player player) {
        Objects.requireNonNull(player, "player");
        return this.get(player) != null;
    }

    @Override
    @NotNull
    public SpectateManager.Result startSpectating(@NotNull Player player, @NotNull Player target) {
        Objects.requireNonNull(player, "player");
        Objects.requireNonNull(target, "target");
        if (this.isSpectating(player)) {
            return SpectateManager.Result.ALREADY_SPECTATING;
        }
        if (this.plugin.getQueueManager().isInQueue(player)) {
            return SpectateManager.Result.IN_QUEUE;
        }
        if (this.arenaManager.isInMatch(player)) {
            return SpectateManager.Result.IN_MATCH;
        }
        ArenaImpl arena = this.arenaManager.get(target);
        if (arena == null) {
            return SpectateManager.Result.TARGET_NOT_IN_MATCH;
        }
        SpectatorImpl spectator = new SpectatorImpl(player, target, arena);
        SpectateStartEvent event = new SpectateStartEvent(player, spectator);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return SpectateManager.Result.EVENT_CANCELLED;
        }
        DuelMatch match = arena.getMatch();
        if (match != null) {
            match.getAllPlayers().stream().filter(arenaPlayer -> arenaPlayer.isOnline() && arenaPlayer.canSee(player)).forEach(arenaPlayer -> {
                if (CompatUtil.hasHidePlayer()) {
                    arenaPlayer.hidePlayer((Plugin)this.plugin, player);
                } else {
                    arenaPlayer.hidePlayer(player);
                }
            });
        }
        if (this.myPet != null) {
            this.myPet.removePet(player);
        }
        this.playerManager.create(player);
        PlayerUtil.reset(player);
        this.teleport.tryTeleport(player, target.getLocation().clone().add(0.0, 2.0, 0.0));
        this.spectators.put(player.getUniqueId(), spectator);
        this.arenas.put((Object)arena, (Object)spectator);
        DuelsPlugin.getMorePaperLib().scheduling().entitySpecificScheduler((Entity)player).run(() -> {
            if (!this.config.isSpecUseSpectatorGamemode()) {
                player.setGameMode(GameMode.ADVENTURE);
                player.setAllowFlight(true);
                player.setFlying(true);
            } else {
                player.setGameMode(GameMode.SPECTATOR);
            }
            player.setCollidable(false);
            if (this.config.isSpecAddInvisibilityEffect()) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 1, false, false));
            }
            if (!player.hasPermission("duels.spectate.anonymously")) {
                arena.getMatch().getAllPlayers().forEach(matchPlayer -> this.lang.sendMessage((CommandSender)matchPlayer, "SPECTATE.arena-broadcast", "name", player.getName()));
            }
        }, null);
        return SpectateManager.Result.SUCCESS;
    }

    public void stopSpectating(Player player, SpectatorImpl spectator) {
        this.spectators.remove(player.getUniqueId());
        this.arenas.remove((Object)spectator.getArena(), (Object)spectator);
        player.setGameMode(GameMode.SURVIVAL);
        player.setFlying(false);
        player.setAllowFlight(false);
        PlayerUtil.reset(player);
        player.setCollidable(true);
        PlayerInfo info = this.playerManager.remove(player);
        if (info != null) {
            this.teleport.tryTeleport(player, info.getLocation());
            info.restore(player);
        } else {
            this.teleport.tryTeleport(player, this.playerManager.getLobby());
        }
        DuelMatch match = spectator.getArena().getMatch();
        if (!(match == null || this.essentials != null && this.essentials.isVanished(player))) {
            match.getAllPlayers().stream().filter(OfflinePlayer::isOnline).forEach(arenaPlayer -> {
                if (CompatUtil.hasHidePlayer()) {
                    arenaPlayer.showPlayer((Plugin)this.plugin, player);
                } else {
                    arenaPlayer.showPlayer(player);
                }
            });
        }
        SpectateEndEvent event = new SpectateEndEvent(player, spectator);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    @Override
    public void stopSpectating(@NotNull Player player) {
        Objects.requireNonNull(player, "player");
        this.stopSpectating(player, this.get(player));
    }

    public void stopSpectating(ArenaImpl arena) {
        Collection spectators = (Collection)this.arenas.asMap().remove(arena);
        if (spectators == null || spectators.isEmpty()) {
            return;
        }
        spectators.forEach(spectator -> {
            Player player = Bukkit.getPlayer((UUID)spectator.getUuid());
            if (player == null) {
                return;
            }
            this.stopSpectating(player, (SpectatorImpl)spectator);
            this.lang.sendMessage((CommandSender)player, "SPECTATE.match-end", new Object[0]);
        });
    }

    @Override
    @NotNull
    public List<Spectator> getSpectators(@NotNull Arena arena) {
        Objects.requireNonNull(arena, "arena");
        return Collections.unmodifiableList(Lists.newArrayList(this.getSpectatorsImpl(arena)));
    }

    public Collection<SpectatorImpl> getSpectatorsImpl(Arena arena) {
        return this.arenas.asMap().getOrDefault(arena, Collections.emptyList());
    }

    public Collection<Player> getAllSpectators() {
        return this.spectators.values().stream().map(spectator -> Bukkit.getPlayer((UUID)spectator.getUuid())).collect(Collectors.toList());
    }

    private class SpectateListener
    implements Listener {
        private SpectateListener() {
        }

        @EventHandler
        public void on(PlayerQuitEvent event) {
            Player player = event.getPlayer();
            SpectatorImpl spectator = SpectateManagerImpl.this.get(player);
            if (spectator == null) {
                return;
            }
            SpectateManagerImpl.this.stopSpectating(player, spectator);
        }

        @EventHandler(ignoreCancelled=true)
        public void on(PlayerCommandPreprocessEvent event) {
            Player player = event.getPlayer();
            if (!SpectateManagerImpl.this.isSpectating(player)) {
                return;
            }
            String command = event.getMessage().substring(1).split(" ")[0].toLowerCase();
            if (command.equalsIgnoreCase("spectate") || command.equalsIgnoreCase("spec") || SpectateManagerImpl.this.config.getSpecWhitelistedCommands().contains(command)) {
                return;
            }
            event.setCancelled(true);
            SpectateManagerImpl.this.lang.sendMessage((CommandSender)player, "SPECTATE.prevent.command", "command", event.getMessage());
        }

        @EventHandler(ignoreCancelled=true)
        public void on(PlayerTeleportEvent event) {
            Player player = event.getPlayer();
            SpectatorImpl spectator = SpectateManagerImpl.this.get(player);
            if (spectator == null) {
                return;
            }
            event.setCancelled(true);
            SpectateManagerImpl.this.lang.sendMessage((CommandSender)player, "SPECTATE.prevent.teleportation", new Object[0]);
        }

        @EventHandler(ignoreCancelled=true)
        public void on(PlayerInteractEvent event) {
            if (!SpectateManagerImpl.this.isSpectating(event.getPlayer())) {
                return;
            }
            event.setCancelled(true);
        }

        @EventHandler(ignoreCancelled=true)
        public void on(PlayerPickupItemEvent event) {
            if (!SpectateManagerImpl.this.isSpectating(event.getPlayer())) {
                return;
            }
            event.setCancelled(true);
        }

        @EventHandler(ignoreCancelled=true)
        public void on(EntityDamageByEntityEvent event) {
            Player damager = EventUtil.getDamager(event);
            if (damager == null || !SpectateManagerImpl.this.isSpectating(damager)) {
                return;
            }
            event.setCancelled(true);
        }

        @EventHandler(ignoreCancelled=true)
        public void on(VehicleDamageEvent event) {
            if (!(event.getAttacker() instanceof Player) || !SpectateManagerImpl.this.isSpectating((Player)event.getAttacker())) {
                return;
            }
            event.setCancelled(true);
        }

        @EventHandler(ignoreCancelled=true)
        public void on(EntityDamageEvent event) {
            if (!(event.getEntity() instanceof Player) || !SpectateManagerImpl.this.isSpectating((Player)event.getEntity())) {
                return;
            }
            event.setCancelled(true);
        }

        @EventHandler
        public void on(BlockCanBuildEvent event) {
            if (!CompatUtil.hasGetPlayer() || SpectateManagerImpl.this.config.isSpecUseSpectatorGamemode()) {
                return;
            }
            Player player = event.getPlayer();
            if (player == null || BlockUtil.near(player, event.getBlock(), 0, 2)) {
                return;
            }
            ArenaImpl arena = SpectateManagerImpl.this.arenaManager.get(player);
            if (arena == null) {
                return;
            }
            for (SpectatorImpl spectator : SpectateManagerImpl.this.getSpectatorsImpl(arena)) {
                Player specPlayer = spectator.getPlayer();
                if (specPlayer == null || !BlockUtil.near(specPlayer, event.getBlock(), 1, 2)) continue;
                event.setBuildable(true);
                break;
            }
        }
    }
}

