/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.util.json;

import com.meteordevelopments.duels.shaded.jackson.annotation.JsonAutoDetect;
import com.meteordevelopments.duels.shaded.jackson.annotation.PropertyAccessor;
import com.meteordevelopments.duels.shaded.jackson.core.JsonFactory;
import com.meteordevelopments.duels.shaded.jackson.core.JsonGenerator;
import com.meteordevelopments.duels.shaded.jackson.core.JsonParser;
import com.meteordevelopments.duels.shaded.jackson.core.PrettyPrinter;
import com.meteordevelopments.duels.shaded.jackson.core.util.DefaultIndenter;
import com.meteordevelopments.duels.shaded.jackson.core.util.DefaultPrettyPrinter;
import com.meteordevelopments.duels.shaded.jackson.core.util.Separators;
import com.meteordevelopments.duels.shaded.jackson.databind.BeanDescription;
import com.meteordevelopments.duels.shaded.jackson.databind.DeserializationConfig;
import com.meteordevelopments.duels.shaded.jackson.databind.DeserializationFeature;
import com.meteordevelopments.duels.shaded.jackson.databind.JsonDeserializer;
import com.meteordevelopments.duels.shaded.jackson.databind.ObjectMapper;
import com.meteordevelopments.duels.shaded.jackson.databind.ObjectWriter;
import com.meteordevelopments.duels.shaded.jackson.databind.deser.BeanDeserializerModifier;
import com.meteordevelopments.duels.shaded.jackson.databind.json.JsonMapper;
import com.meteordevelopments.duels.shaded.jackson.databind.module.SimpleModule;
import com.meteordevelopments.duels.util.json.DefaultBasedDeserializer;
import java.lang.reflect.InvocationTargetException;
import org.jetbrains.annotations.NotNull;

public final class JsonUtil {
    private static final ObjectMapper OBJECT_MAPPER;
    private static final ObjectWriter OBJECT_WRITER;

    private JsonUtil() {
    }

    public static ObjectMapper getObjectMapper() {
        return OBJECT_MAPPER;
    }

    public static ObjectWriter getObjectWriter() {
        return OBJECT_WRITER;
    }

    public static <T> void registerDeserializer(final Class<T> type, final Class<? extends DefaultBasedDeserializer<T>> deserializerClass) {
        SimpleModule module = new SimpleModule();
        module.setDeserializerModifier(new BeanDeserializerModifier(){

            @Override
            public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription description, JsonDeserializer<?> deserializer) {
                if (description.getBeanClass().equals(type)) {
                    try {
                        return (JsonDeserializer)deserializerClass.getConstructor(JsonDeserializer.class).newInstance(deserializer);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                        ex.printStackTrace();
                        return deserializer;
                    }
                }
                return deserializer;
            }
        });
        OBJECT_MAPPER.registerModule(module);
    }

    private static PrettyPrinter buildDefaultPrettyPrinter() {
        DefaultPrettyPrinter printer = new DefaultPrettyPrinter(){

            @Override
            public DefaultPrettyPrinter withSeparators(Separators separators) {
                this._separators = separators;
                this._objectFieldValueSeparatorWithSpaces = separators.getObjectFieldValueSeparator() + " ";
                return this;
            }

            @Override
            @NotNull
            public DefaultPrettyPrinter createInstance() {
                return new DefaultPrettyPrinter(this);
            }
        };
        printer.indentArraysWith(DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
        printer.indentObjectsWith(DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
        return printer;
    }

    static {
        JsonFactory factory = new JsonFactory();
        factory.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        factory.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        OBJECT_MAPPER = JsonMapper.builder(factory).build();
        OBJECT_MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        OBJECT_MAPPER.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        OBJECT_MAPPER.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        OBJECT_WRITER = OBJECT_MAPPER.writer(JsonUtil.buildDefaultPrettyPrinter());
    }
}

