/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.validator.validators.match;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.setting.Settings;
import com.meteordevelopments.duels.validator.BaseBiValidator;
import java.util.Collection;
import org.bukkit.entity.Player;

public class BlacklistedWorldValidator
extends BaseBiValidator<Collection<Player>, Settings> {
    private static final String MESSAGE_KEY = "DUEL.start-failure.in-blacklisted-world";
    private static final String PARTY_MESSAGE_KEY = "DUEL.party-start-failure.in-blacklisted-world";

    public BlacklistedWorldValidator(DuelsPlugin plugin) {
        super(plugin);
    }

    @Override
    public boolean shouldValidate() {
        return !this.config.getBlacklistedWorlds().isEmpty();
    }

    private boolean isBlacklistedWorld(Player player) {
        return this.config.getBlacklistedWorlds().contains(player.getWorld().getName());
    }

    @Override
    public boolean validate(Collection<Player> players, Settings settings) {
        if (players.stream().anyMatch(this::isBlacklistedWorld)) {
            this.lang.sendMessage(players, settings.isPartyDuel() ? PARTY_MESSAGE_KEY : MESSAGE_KEY, new Object[0]);
            return false;
        }
        return true;
    }
}

