/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels;

import com.google.common.collect.Lists;
import com.meteordevelopments.duels-optimised.shaded.morepaperlib.MorePaperLib;
import com.meteordevelopments.duels-optimised.shaded.morepaperlib.scheduling.ScheduledTask;
import com.meteordevelopments.duels.api.Duels;
import com.meteordevelopments.duels.api.command.SubCommand;
import com.meteordevelopments.duels.arena.ArenaManagerImpl;
import com.meteordevelopments.duels.betting.BettingManager;
import com.meteordevelopments.duels.command.commands.KitCommand;
import com.meteordevelopments.duels.command.commands.SpectateCommand;
import com.meteordevelopments.duels.command.commands.duel.DuelCommand;
import com.meteordevelopments.duels.command.commands.duels.DuelsCommand;
import com.meteordevelopments.duels.command.commands.party.PartyCommand;
import com.meteordevelopments.duels.command.commands.queue.QueueCommand;
import com.meteordevelopments.duels.config.Config;
import com.meteordevelopments.duels.config.Lang;
import com.meteordevelopments.duels.data.ItemData;
import com.meteordevelopments.duels.data.UserManagerImpl;
import com.meteordevelopments.duels.duel.DuelManager;
import com.meteordevelopments.duels.extension.ExtensionClassLoader;
import com.meteordevelopments.duels.extension.ExtensionManager;
import com.meteordevelopments.duels.hook.HookManager;
import com.meteordevelopments.duels.inventories.InventoryManager;
import com.meteordevelopments.duels.kit.KitManagerImpl;
import com.meteordevelopments.duels.kit.edit.KitEditListener;
import com.meteordevelopments.duels.kit.edit.KitEditManager;
import com.meteordevelopments.duels.listeners.DamageListener;
import com.meteordevelopments.duels.listeners.EnderpearlListener;
import com.meteordevelopments.duels.listeners.ExplosionOwnershipListener;
import com.meteordevelopments.duels.listeners.KitItemListener;
import com.meteordevelopments.duels.listeners.KitOptionsListener;
import com.meteordevelopments.duels.listeners.LingerPotionListener;
import com.meteordevelopments.duels.listeners.PotionListener;
import com.meteordevelopments.duels.listeners.ProjectileHitListener;
import com.meteordevelopments.duels.listeners.TeamDamageListener;
import com.meteordevelopments.duels.listeners.TeleportListener;
import com.meteordevelopments.duels.logging.LogManager;
import com.meteordevelopments.duels.party.PartyManagerImpl;
import com.meteordevelopments.duels.player.PlayerInfoManager;
import com.meteordevelopments.duels.queue.QueueManager;
import com.meteordevelopments.duels.queue.sign.QueueSignManagerImpl;
import com.meteordevelopments.duels.request.RequestManager;
import com.meteordevelopments.duels.setting.SettingsManager;
import com.meteordevelopments.duels.shaded.bstats.Metrics;
import com.meteordevelopments.duels.spectate.SpectateManagerImpl;
import com.meteordevelopments.duels.teleport.Teleport;
import com.meteordevelopments.duels.util.Loadable;
import com.meteordevelopments.duels.util.Log;
import com.meteordevelopments.duels.util.Reloadable;
import com.meteordevelopments.duels.util.UpdateManager;
import com.meteordevelopments.duels.util.command.AbstractCommand;
import com.meteordevelopments.duels.util.gui.GuiListener;
import com.meteordevelopments.duels.util.json.JsonUtil;
import com.meteordevelopments.duels.util.util.CC;
import com.meteordevelopments.duels.validator.ValidatorManager;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class DuelsPlugin
extends JavaPlugin
implements Duels,
Log.LogSource {
    private static final int BSTATS_ID = 20778;
    private static final String SPIGOT_INSTALLATION_URL = "https://www.spigotmc.org/wiki/spigot-installation/";
    private UpdateManager updateManager;
    private static DuelsPlugin instance;
    private static MorePaperLib morePaperLib;
    private final List<Loadable> loadables = new ArrayList<Loadable>();
    private final Map<String, AbstractCommand<DuelsPlugin>> commands = new HashMap<String, AbstractCommand<DuelsPlugin>>();
    private final List<Listener> registeredListeners = new ArrayList<Listener>();
    private int lastLoad;
    private LogManager logManager;
    private Config configuration;
    private Lang lang;
    private UserManagerImpl userManager;
    private GuiListener<DuelsPlugin> guiListener;
    private KitManagerImpl kitManager;
    private ArenaManagerImpl arenaManager;
    private SettingsManager settingManager;
    private PlayerInfoManager playerManager;
    private SpectateManagerImpl spectateManager;
    private BettingManager bettingManager;
    private InventoryManager inventoryManager;
    private DuelManager duelManager;
    private QueueManager queueManager;
    private QueueSignManagerImpl queueSignManager;
    private RequestManager requestManager;
    private HookManager hookManager;
    private Teleport teleport;
    private ExtensionManager extensionManager;
    private PartyManagerImpl partyManager;
    private ValidatorManager validatorManager;
    private static final Logger LOGGER;

    public void onEnable() {
        instance = this;
        morePaperLib = new MorePaperLib(this);
        Log.addSource(this);
        JsonUtil.registerDeserializer(ItemData.class, ItemData.ItemDataDeserializer.class);
        this.sendBanner();
        long start = System.currentTimeMillis();
        this.loadLogManager();
        this.initLoadables();
        this.loadPreListeners();
        long end = System.currentTimeMillis();
        DuelsPlugin.sendMessage("&2Successfully enabled Duels in " + CC.getTimeDifferenceAndColor(start, end) + "&a.");
        this.checkForUpdatesAndMetrics();
    }

    public void onDisable() {
        long start;
        long last = start = System.currentTimeMillis();
        this.logManager.debug("onDisable start -> " + start + "\n");
        this.unload();
        long l = last;
        last = System.currentTimeMillis();
        this.logManager.debug("unload done (took " + Math.abs(l - last) + "ms)");
        Log.clearSources();
        this.logManager.debug("Log#clearSources done (took " + Math.abs(last - System.currentTimeMillis()) + "ms)");
        this.logManager.handleDisable();
        instance = null;
        DuelsPlugin.sendMessage("&2Disable process took " + (System.currentTimeMillis() - start) + "ms.");
    }

    private boolean load() {
        this.registerCommands(new DuelCommand(this), new PartyCommand(this), new QueueCommand(this), new SpectateCommand(this), new DuelsCommand(this), new KitCommand(this));
        for (Loadable loadable : this.loadables) {
            String name = loadable.getClass().getSimpleName();
            try {
                long now = System.currentTimeMillis();
                this.logManager.debug("Starting load of " + name + " at " + now);
                loadable.handleLoad();
                this.logManager.debug(name + " has been loaded. (took " + (System.currentTimeMillis() - now) + "ms)");
                this.lastLoad = this.loadables.indexOf(loadable);
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Error loading " + name, ex);
                if (loadable instanceof Log.LogSource) {
                    LOGGER.log(Level.SEVERE, "Error loading ", ex);
                }
                DuelsPlugin.sendMessage("&c&lThere was an error while loading " + name + "! If you believe this is an issue from the plugin, please contact the developer.");
                return false;
            }
        }
        return true;
    }

    private boolean unload() {
        this.registeredListeners.forEach(HandlerList::unregisterAll);
        this.registeredListeners.clear();
        HandlerList.getRegisteredListeners((Plugin)this).stream().filter(listener -> listener.getListener().getClass().getClassLoader().getClass().isAssignableFrom(ExtensionClassLoader.class)).forEach(listener -> HandlerList.unregisterAll((Listener)listener.getListener()));
        this.commands.clear();
        for (Loadable loadable : Lists.reverse(this.loadables)) {
            String name = loadable.getClass().getSimpleName();
            try {
                if (this.loadables.indexOf(loadable) > this.lastLoad) continue;
                long now = System.currentTimeMillis();
                this.logManager.debug("Starting unload of " + name + " at " + now);
                loadable.handleUnload();
                this.logManager.debug(name + " has been unloaded. (took " + (System.currentTimeMillis() - now) + "ms)");
            }
            catch (Exception ex) {
                DuelsPlugin.sendMessage("&c&lThere was an error while unloading " + name + "! If you believe this is an issue from the plugin, please contact the developer.");
                return false;
            }
        }
        return true;
    }

    @SafeVarargs
    private void registerCommands(AbstractCommand<DuelsPlugin> ... commands) {
        DuelsPlugin.sendMessage("&eRegistering commands...");
        long start = System.currentTimeMillis();
        for (AbstractCommand<DuelsPlugin> command : commands) {
            this.commands.put(command.getName().toLowerCase(), command);
            command.register();
        }
        DuelsPlugin.sendMessage("&dSuccessfully registered commands [" + CC.getTimeDifferenceAndColor(start, System.currentTimeMillis()) + String.valueOf(ChatColor.WHITE) + "]");
    }

    @Override
    public boolean registerSubCommand(@NotNull String command, final @NotNull SubCommand subCommand) {
        Objects.requireNonNull(command, "command");
        Objects.requireNonNull(subCommand, "subCommand");
        AbstractCommand<DuelsPlugin> result = this.commands.get(command.toLowerCase());
        if (result == null || result.isChild(subCommand.getName().toLowerCase())) {
            return false;
        }
        result.child(new AbstractCommand<DuelsPlugin>(this, this, subCommand){

            @Override
            protected void execute(CommandSender sender, String label, String[] args) {
                subCommand.execute(sender, label, args);
            }
        });
        return true;
    }

    @Override
    public void registerListener(@NotNull Listener listener) {
        DuelsPlugin.sendMessage("&eRegistering post listeners...");
        long start = System.currentTimeMillis();
        Objects.requireNonNull(listener, "listener");
        this.registeredListeners.add(listener);
        Bukkit.getPluginManager().registerEvents(listener, (Plugin)this);
        DuelsPlugin.sendMessage("&dSuccessfully registered listeners after plugin startup in [" + CC.getTimeDifferenceAndColor(start, System.currentTimeMillis()) + String.valueOf(ChatColor.WHITE) + "]");
    }

    @Override
    public boolean reload() {
        if (!this.unload() || !this.load()) {
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return false;
        }
        return true;
    }

    @Override
    public String getVersion() {
        return this.getDescription().getVersion();
    }

    public boolean reload(Loadable loadable) {
        boolean unloaded = false;
        try {
            loadable.handleUnload();
            unloaded = true;
            loadable.handleLoad();
            return true;
        }
        catch (Exception ex) {
            DuelsPlugin.sendMessage("&c&lThere was an error while " + (unloaded ? "loading " : "unloading ") + loadable.getClass().getSimpleName() + "! If you believe this is an issue from the plugin, please contact the developer.");
            return false;
        }
    }

    @Override
    public ScheduledTask doSync(@NotNull Runnable task) {
        Objects.requireNonNull(task, "task");
        return morePaperLib.scheduling().globalRegionalScheduler().run(task);
    }

    @Override
    public ScheduledTask doSyncAfter(@NotNull Runnable task, long delay) {
        Objects.requireNonNull(task, "task");
        return morePaperLib.scheduling().globalRegionalScheduler().runDelayed(task, delay);
    }

    @Override
    public ScheduledTask doSyncRepeat(@NotNull Runnable task, long delay, long period) {
        Objects.requireNonNull(task, "task");
        long safeDelay = Math.max(1L, delay);
        return morePaperLib.scheduling().globalRegionalScheduler().runAtFixedRate(task, safeDelay, period);
    }

    @Override
    public ScheduledTask doAsync(@NotNull Runnable task) {
        Objects.requireNonNull(task, "task");
        return morePaperLib.scheduling().asyncScheduler().run(task);
    }

    @Override
    public ScheduledTask doAsyncAfter(@NotNull Runnable task, long delay) {
        Objects.requireNonNull(task, "task");
        return morePaperLib.scheduling().asyncScheduler().runDelayed(task, Duration.ofMillis(delay * 50L));
    }

    @Override
    public ScheduledTask doAsyncRepeat(@NotNull Runnable task, long delay, long period) {
        Objects.requireNonNull(task, "task");
        return morePaperLib.scheduling().asyncScheduler().runAtFixedRate(task, Duration.ofMillis(delay * 50L), Duration.ofMillis(period * 50L));
    }

    @Override
    public void cancelTask(@NotNull ScheduledTask task) {
        Objects.requireNonNull(task, "task");
        task.cancel();
    }

    @Override
    public void info(@NotNull String message) {
        Objects.requireNonNull(message, "message");
        Log.info(message);
    }

    @Override
    public void warn(@NotNull String message) {
        Objects.requireNonNull(message, "message");
        Log.warn(message);
    }

    @Override
    public void error(@NotNull String message) {
        Objects.requireNonNull(message, "message");
        Log.error(message);
    }

    @Override
    public void error(@NotNull String message, @NotNull Throwable thrown) {
        Objects.requireNonNull(message, "message");
        Objects.requireNonNull(thrown, "thrown");
        Log.error(message, thrown);
    }

    public Loadable find(String name) {
        return this.loadables.stream().filter(loadable -> loadable.getClass().getSimpleName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public List<String> getReloadables() {
        return this.loadables.stream().filter(loadable -> loadable instanceof Reloadable).map(loadable -> loadable.getClass().getSimpleName()).collect(Collectors.toList());
    }

    @Override
    public void log(Level level, String s) {
        this.getLogger().log(level, s);
    }

    @Override
    public void log(Level level, String s, Throwable thrown) {
        this.getLogger().log(level, s, thrown);
    }

    public static String getPrefix() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)"&b&lDuels Optimised &7\u00bb ");
    }

    public static void sendMessage(String message) {
        Bukkit.getConsoleSender().sendMessage(DuelsPlugin.getPrefix() + CC.translate(message));
    }

    private void sendBanner() {
        String[] banner;
        for (String lines : banner = new String[]{"\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557", "\u2551  \u2588\u2588\u2588\u2588\u2588\u2588\u2557 \u2588\u2588\u2557   \u2588\u2588\u2557\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557\u2588\u2588\u2557     \u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557     \u2588\u2588\u2588\u2588\u2588\u2588\u2557 \u2588\u2588\u2588\u2588\u2588\u2588\u2557 \u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557\u2588\u2588\u2557\u2588\u2588\u2588\u2557   \u2588\u2588\u2588\u2557\u2588\u2588\u2557\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557\u2588\u2588\u2588\u2588\u2588\u2588\u2557  \u2551", "\u2551  \u2588\u2588\u2554\u2550\u2550\u2588\u2588\u2557\u2588\u2588\u2551   \u2588\u2588\u2551\u2588\u2588\u2554\u2550\u2550\u2550\u2550\u255d\u2588\u2588\u2551     \u2588\u2588\u2554\u2550\u2550\u2550\u2550\u255d    \u2588\u2588\u2554\u2550\u2550\u2550\u2588\u2588\u2557\u2588\u2588\u2554\u2550\u2550\u2588\u2588\u2557\u255a\u2550\u2550\u2588\u2588\u2554\u2550\u2550\u255d\u2588\u2588\u2551\u2588\u2588\u2588\u2588\u2557 \u2588\u2588\u2588\u2588\u2551\u2588\u2588\u2551\u2588\u2588\u2554\u2550\u2550\u2550\u2550\u255d\u2588\u2588\u2554\u2550\u2550\u2550\u2550\u255d\u2588\u2588\u2554\u2550\u2550\u2588\u2588\u2557 \u2551", "\u2551  \u2588\u2588\u2551  \u2588\u2588\u2551\u2588\u2588\u2551   \u2588\u2588\u2551\u2588\u2588\u2588\u2588\u2588\u2557  \u2588\u2588\u2551     \u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557    \u2588\u2588\u2551   \u2588\u2588\u2551\u2588\u2588\u2588\u2588\u2588\u2588\u2554\u255d   \u2588\u2588\u2551   \u2588\u2588\u2551\u2588\u2588\u2554\u2588\u2588\u2588\u2588\u2554\u2588\u2588\u2551\u2588\u2588\u2551\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557\u2588\u2588\u2588\u2588\u2588\u2557  \u2588\u2588\u2551  \u2588\u2588\u2551 \u2551", "\u2551  \u2588\u2588\u2551  \u2588\u2588\u2551\u2588\u2588\u2551   \u2588\u2588\u2551\u2588\u2588\u2554\u2550\u2550\u255d  \u2588\u2588\u2551     \u255a\u2550\u2550\u2550\u2550\u2588\u2588\u2551    \u2588\u2588\u2551   \u2588\u2588\u2551\u2588\u2588\u2554\u2550\u2550\u2550\u255d    \u2588\u2588\u2551   \u2588\u2588\u2551\u2588\u2588\u2551\u255a\u2588\u2588\u2554\u255d\u2588\u2588\u2551\u2588\u2588\u2551\u255a\u2550\u2550\u2550\u2550\u2588\u2588\u2551\u2588\u2588\u2554\u2550\u2550\u255d  \u2588\u2588\u2551  \u2588\u2588\u2551 \u2551", "\u2551  \u2588\u2588\u2588\u2588\u2588\u2588\u2554\u255d\u255a\u2588\u2588\u2588\u2588\u2588\u2588\u2554\u255d\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2551    \u255a\u2588\u2588\u2588\u2588\u2588\u2588\u2554\u255d\u2588\u2588\u2551        \u2588\u2588\u2551   \u2588\u2588\u2551\u2588\u2588\u2551 \u255a\u2550\u255d \u2588\u2588\u2551\u2588\u2588\u2551\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2551\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557\u2588\u2588\u2588\u2588\u2588\u2588\u2554\u255d \u2551", "\u2551  \u255a\u2550\u2550\u2550\u2550\u2550\u255d  \u255a\u2550\u2550\u2550\u2550\u2550\u255d \u255a\u2550\u2550\u2550\u2550\u2550\u2550\u255d\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u255d\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u255d     \u255a\u2550\u2550\u2550\u2550\u2550\u255d \u255a\u2550\u255d        \u255a\u2550\u255d   \u255a\u2550\u255d\u255a\u2550\u255d     \u255a\u2550\u255d\u255a\u2550\u255d\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u255d\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u255d\u255a\u2550\u2550\u2550\u2550\u2550\u255d  \u2551", "\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d"}) {
            Bukkit.getConsoleSender().sendMessage(CC.translate("&a" + lines));
        }
    }

    private void loadLogManager() {
        long start = System.currentTimeMillis();
        DuelsPlugin.sendMessage("&eStarting to load log manager");
        try {
            this.logManager = new LogManager(this);
        }
        catch (IOException ex) {
            DuelsPlugin.sendMessage("&c&lCould not load LogManager. Please contact the developer.");
            LOGGER.log(Level.SEVERE, "Could not load LogManager. Please contact the developer.", ex);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        Log.addSource(this.logManager);
        this.logManager.debug("onEnable start -> " + System.currentTimeMillis() + "\n");
        try {
            Class.forName("org.spigotmc.SpigotConfig");
        }
        catch (ClassNotFoundException ex) {
            DuelsPlugin.sendMessage("&c&l================= *** DUELS LOAD FAILURE *** =================");
            DuelsPlugin.sendMessage("&c&lDuels requires a spigot server to run, but this server was not running on spigot!");
            DuelsPlugin.sendMessage("&c&lTo run your server on spigot, follow this guide: https://www.spigotmc.org/wiki/spigot-installation/");
            DuelsPlugin.sendMessage("&c&lSpigot is compatible with CraftBukkit/Bukkit plugins.");
            DuelsPlugin.sendMessage("&c&l================= *** DUELS LOAD FAILURE *** =================");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
        DuelsPlugin.sendMessage("&dSuccessfully loaded Log Manager in &f[" + CC.getTimeDifferenceAndColor(start, System.currentTimeMillis()) + "&f]");
    }

    private void initLoadables() {
        long start = System.currentTimeMillis();
        DuelsPlugin.sendMessage("&eStarting to load loadables");
        this.loadAndTrack("config", () -> {
            this.configuration = new Config(this);
            this.loadables.add(this.configuration);
        });
        this.loadAndTrack("lang", () -> {
            this.lang = new Lang(this);
            this.loadables.add(this.lang);
        });
        this.loadAndTrack("user manager", () -> {
            this.userManager = new UserManagerImpl(this);
            this.loadables.add(this.userManager);
        });
        this.loadAndTrack("gui listener", () -> {
            this.guiListener = new GuiListener<DuelsPlugin>(this);
            this.loadables.add(this.guiListener);
        });
        this.loadAndTrack("party manager", () -> {
            this.partyManager = new PartyManagerImpl(this);
            this.loadables.add(this.partyManager);
        });
        this.loadAndTrack("kit manager", () -> {
            this.kitManager = new KitManagerImpl(this);
            this.loadables.add(this.kitManager);
        });
        this.loadAndTrack("arena manager", () -> {
            this.arenaManager = new ArenaManagerImpl(this);
            this.loadables.add(this.arenaManager);
        });
        this.loadAndTrack("settings manager", () -> {
            this.settingManager = new SettingsManager(this);
            this.loadables.add(this.settingManager);
        });
        this.loadAndTrack("player manager", () -> {
            this.playerManager = new PlayerInfoManager(this);
            this.loadables.add(this.playerManager);
        });
        this.loadAndTrack("spectate manager", () -> {
            this.spectateManager = new SpectateManagerImpl(this);
            this.loadables.add(this.spectateManager);
        });
        this.loadAndTrack("betting manager", () -> {
            this.bettingManager = new BettingManager(this);
            this.loadables.add(this.bettingManager);
        });
        this.loadAndTrack("inventory manager", () -> {
            this.inventoryManager = new InventoryManager(this);
            this.loadables.add(this.inventoryManager);
        });
        this.loadAndTrack("duel manager", () -> {
            this.duelManager = new DuelManager(this);
            this.loadables.add(this.duelManager);
        });
        this.loadAndTrack("queue manager", () -> {
            this.queueManager = new QueueManager(this);
            this.loadables.add(this.queueManager);
        });
        this.loadAndTrack("queue signs", () -> {
            this.queueSignManager = new QueueSignManagerImpl(this);
            this.loadables.add(this.queueSignManager);
        });
        this.loadAndTrack("request manager", () -> {
            this.requestManager = new RequestManager(this);
            this.loadables.add(this.requestManager);
        });
        this.loadAndTrack("hook manager", () -> {
            this.hookManager = new HookManager(this);
        });
        this.loadAndTrack("validator manager", () -> {
            this.validatorManager = new ValidatorManager(this);
            this.loadables.add(this.validatorManager);
        });
        this.loadAndTrack("teleport manager", () -> {
            this.teleport = new Teleport(this);
            this.loadables.add(this.teleport);
        });
        this.loadAndTrack("extension manager", () -> {
            this.extensionManager = new ExtensionManager(this);
            this.loadables.add(this.extensionManager);
        });
        if (!this.load()) {
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        DuelsPlugin.sendMessage("&dSuccessfully loaded all loadables in &f[" + CC.getTimeDifferenceAndColor(start, System.currentTimeMillis()) + "&f]");
    }

    private void loadAndTrack(String name, Runnable task) {
        long start = System.currentTimeMillis();
        try {
            task.run();
            DuelsPlugin.sendMessage("&2Successfully loaded " + name + " in &f[" + CC.getTimeDifferenceAndColor(start, System.currentTimeMillis()) + "&f]");
        }
        catch (Exception e) {
            DuelsPlugin.sendMessage("&cFailed to load " + name + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void loadPreListeners() {
        long start = System.currentTimeMillis();
        DuelsPlugin.sendMessage("&eStarting to load pre-listeners");
        new KitItemListener(this);
        new DamageListener(this);
        new ExplosionOwnershipListener(this);
        new TeamDamageListener(this);
        new PotionListener(this);
        new TeleportListener(this);
        new ProjectileHitListener(this);
        new EnderpearlListener(this);
        new KitOptionsListener(this);
        new LingerPotionListener(this);
        new KitEditManager(this);
        this.registerListener(new KitEditListener(this));
        DuelsPlugin.sendMessage("&dSuccessfully loaded pre-listeners in &f[" + CC.getTimeDifferenceAndColor(start, System.currentTimeMillis()) + "&f]");
    }

    private void checkForUpdatesAndMetrics() {
        new Metrics(this, 20778);
        if (!this.configuration.isCheckForUpdates()) {
            return;
        }
        this.updateManager = new UpdateManager(this);
        this.updateManager.checkForUpdate();
        if (this.updateManager.updateIsAvailable()) {
            DuelsPlugin.sendMessage("&a===============================================");
            DuelsPlugin.sendMessage("&aAn update for " + this.getName() + " is available!");
            DuelsPlugin.sendMessage("&aDownload " + this.getName() + " v" + this.updateManager.getLatestVersion() + " here:");
            DuelsPlugin.sendMessage("&e" + this.getDescription().getWebsite());
            DuelsPlugin.sendMessage("&a===============================================");
        }
    }

    @Generated
    public UpdateManager getUpdateManager() {
        return this.updateManager;
    }

    @Generated
    public static DuelsPlugin getInstance() {
        return instance;
    }

    @Generated
    public static MorePaperLib getMorePaperLib() {
        return morePaperLib;
    }

    @Generated
    public LogManager getLogManager() {
        return this.logManager;
    }

    @Generated
    public Config getConfiguration() {
        return this.configuration;
    }

    @Generated
    public Lang getLang() {
        return this.lang;
    }

    @Override
    @Generated
    public UserManagerImpl getUserManager() {
        return this.userManager;
    }

    @Generated
    public GuiListener<DuelsPlugin> getGuiListener() {
        return this.guiListener;
    }

    @Override
    @Generated
    public KitManagerImpl getKitManager() {
        return this.kitManager;
    }

    @Override
    @Generated
    public ArenaManagerImpl getArenaManager() {
        return this.arenaManager;
    }

    @Generated
    public SettingsManager getSettingManager() {
        return this.settingManager;
    }

    @Generated
    public PlayerInfoManager getPlayerManager() {
        return this.playerManager;
    }

    @Override
    @Generated
    public SpectateManagerImpl getSpectateManager() {
        return this.spectateManager;
    }

    @Generated
    public BettingManager getBettingManager() {
        return this.bettingManager;
    }

    @Generated
    public InventoryManager getInventoryManager() {
        return this.inventoryManager;
    }

    @Generated
    public DuelManager getDuelManager() {
        return this.duelManager;
    }

    @Override
    @Generated
    public QueueManager getQueueManager() {
        return this.queueManager;
    }

    @Override
    @Generated
    public QueueSignManagerImpl getQueueSignManager() {
        return this.queueSignManager;
    }

    @Generated
    public RequestManager getRequestManager() {
        return this.requestManager;
    }

    @Generated
    public HookManager getHookManager() {
        return this.hookManager;
    }

    @Generated
    public Teleport getTeleport() {
        return this.teleport;
    }

    @Generated
    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    @Generated
    public PartyManagerImpl getPartyManager() {
        return this.partyManager;
    }

    @Generated
    public ValidatorManager getValidatorManager() {
        return this.validatorManager;
    }

    static {
        LOGGER = Logger.getLogger("[Duels-Optimised]");
    }
}

