/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.arena;

import com.google.common.base.Charsets;
import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.api.arena.Arena;
import com.meteordevelopments.duels.api.arena.ArenaManager;
import com.meteordevelopments.duels.api.event.arena.ArenaCreateEvent;
import com.meteordevelopments.duels.api.event.arena.ArenaRemoveEvent;
import com.meteordevelopments.duels.arena.ArenaImpl;
import com.meteordevelopments.duels.config.Config;
import com.meteordevelopments.duels.config.Lang;
import com.meteordevelopments.duels.data.ArenaData;
import com.meteordevelopments.duels.kit.KitImpl;
import com.meteordevelopments.duels.queue.Queue;
import com.meteordevelopments.duels.shaded.jackson.core.type.TypeReference;
import com.meteordevelopments.duels.util.Loadable;
import com.meteordevelopments.duels.util.Log;
import com.meteordevelopments.duels.util.StringUtil;
import com.meteordevelopments.duels.util.compat.Items;
import com.meteordevelopments.duels.util.gui.MultiPageGui;
import com.meteordevelopments.duels.util.inventory.ItemBuilder;
import com.meteordevelopments.duels.util.io.FileUtil;
import com.meteordevelopments.duels.util.json.JsonUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArenaManagerImpl
implements Loadable,
ArenaManager {
    private static final String FILE_NAME = "arenas.json";
    private static final String ERROR_NOT_ALPHANUMERIC = "&c&lCould not load arena %s: Name is not alphanumeric.";
    private static final String ARENAS_LOADED = "&2Loaded %s arena(s).";
    private final DuelsPlugin plugin;
    private final Config config;
    private final Lang lang;
    private final File file;
    private final List<ArenaImpl> arenas = new ArrayList<ArenaImpl>();
    private MultiPageGui<DuelsPlugin> gui;

    public ArenaManagerImpl(DuelsPlugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfiguration();
        this.lang = plugin.getLang();
        this.file = new File(plugin.getDataFolder(), FILE_NAME);
        Bukkit.getPluginManager().registerEvents((Listener)new ArenaListener(), (Plugin)plugin);
    }

    @Override
    public void handleLoad() throws IOException {
        this.gui = new MultiPageGui<DuelsPlugin>(this.plugin, this.lang.getMessage("GUI.arena-selector.title"), this.config.getArenaSelectorRows(), this.arenas);
        this.gui.setSpaceFiller(Items.from(this.config.getArenaSelectorFillerType(), this.config.getArenaSelectorFillerData()));
        this.gui.setPrevButton(ItemBuilder.of(Material.PAPER).name(this.lang.getMessage("GUI.kit-selector.buttons.previous-page.name"), this.lang).build());
        this.gui.setNextButton(ItemBuilder.of(Material.PAPER).name(this.lang.getMessage("GUI.kit-selector.buttons.next-page.name"), this.lang).build());
        this.gui.setEmptyIndicator(ItemBuilder.of(Material.PAPER).name(this.lang.getMessage("GUI.kit-selector.buttons.empty.name"), this.lang).build());
        this.plugin.getGuiListener().addGui(this.gui);
        if (FileUtil.checkNonEmpty(this.file, true)) {
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(this.file), Charsets.UTF_8);){
                List<ArenaData> data = JsonUtil.getObjectMapper().readValue((Reader)reader, new TypeReference<List<ArenaData>>(this){});
                if (data != null) {
                    for (ArenaData arenaData : data) {
                        if (!StringUtil.isAlphanumeric(arenaData.getName())) {
                            DuelsPlugin.sendMessage(String.format(ERROR_NOT_ALPHANUMERIC, arenaData.getName()));
                            continue;
                        }
                        this.arenas.add(arenaData.toArena(this.plugin));
                    }
                }
            }
        }
        DuelsPlugin.sendMessage(String.format(ARENAS_LOADED, this.arenas.size()));
        this.gui.calculatePages();
    }

    @Override
    public void handleUnload() {
        if (this.gui != null) {
            this.plugin.getGuiListener().removeGui(this.gui);
        }
        this.arenas.clear();
    }

    void saveArenas() {
        ArrayList<ArenaData> data = new ArrayList<ArenaData>();
        for (ArenaImpl arena : this.arenas) {
            data.add(new ArenaData(arena));
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), Charsets.UTF_8);){
            JsonUtil.getObjectWriter().writeValue(writer, data);
            ((Writer)writer).flush();
        }
        catch (IOException ex) {
            Log.error(this, ex.getMessage(), ex);
        }
    }

    @Override
    @Nullable
    public ArenaImpl get(@NotNull String name) {
        Objects.requireNonNull(name, "name");
        for (ArenaImpl arena : this.arenas) {
            if (!arena.getName().equals(name)) continue;
            return arena;
        }
        return null;
    }

    @Override
    @Nullable
    public ArenaImpl get(@NotNull Player player) {
        Objects.requireNonNull(player, "player");
        for (ArenaImpl arena : this.arenas) {
            if (!arena.has(player)) continue;
            return arena;
        }
        return null;
    }

    @Override
    public boolean isInMatch(@NotNull Player player) {
        Objects.requireNonNull(player, "player");
        return this.get(player) != null;
    }

    @Override
    @NotNull
    public List<Arena> getArenas() {
        return Collections.unmodifiableList(this.arenas);
    }

    public boolean create(CommandSender source, String name) {
        if (this.get(name) != null) {
            return false;
        }
        ArenaImpl arena = new ArenaImpl(this.plugin, name);
        this.arenas.add(arena);
        this.saveArenas();
        Bukkit.getPluginManager().callEvent((Event)new ArenaCreateEvent(source, arena));
        this.gui.calculatePages();
        return true;
    }

    public boolean remove(CommandSender source, ArenaImpl arena) {
        if (this.arenas.remove(arena)) {
            arena.setRemoved(true);
            this.saveArenas();
            Bukkit.getPluginManager().callEvent((Event)new ArenaRemoveEvent(source, arena));
            this.gui.calculatePages();
            return true;
        }
        return false;
    }

    public List<ArenaImpl> getArenasImpl() {
        return this.arenas;
    }

    public Set<Player> getPlayers() {
        HashSet<Player> players = new HashSet<Player>();
        for (ArenaImpl arena : this.arenas) {
            players.addAll(arena.getPlayers());
        }
        return players;
    }

    public long getPlayersInMatch(Queue queue) {
        int count = 0;
        for (ArenaImpl arena : this.arenas) {
            if (!arena.isUsed() || !Objects.requireNonNull(arena.getMatch()).isFromQueue() || !arena.getMatch().getSource().equals(queue)) continue;
            ++count;
        }
        return (long)count * 2L;
    }

    public boolean isSelectable(@Nullable KitImpl kit, @NotNull ArenaImpl arena) {
        if (!arena.isAvailable()) {
            return false;
        }
        if (arena.isBoundless()) {
            return kit == null || !kit.isArenaSpecific();
        }
        return arena.isBound(kit);
    }

    public ArenaImpl randomArena(KitImpl kit) {
        ArrayList<ArenaImpl> available = new ArrayList<ArenaImpl>();
        for (ArenaImpl arena : this.arenas) {
            if (!this.isSelectable(kit, arena)) continue;
            available.add(arena);
        }
        if (!available.isEmpty()) {
            return (ArenaImpl)available.get(ThreadLocalRandom.current().nextInt(available.size()));
        }
        return null;
    }

    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (ArenaImpl arena : this.arenas) {
            names.add(arena.getName());
        }
        return names;
    }

    public void clearBinds(KitImpl kit) {
        for (ArenaImpl arena : this.arenas) {
            if (!arena.isBound(kit)) continue;
            arena.bind(kit);
        }
    }

    @Generated
    public MultiPageGui<DuelsPlugin> getGui() {
        return this.gui;
    }

    private class ArenaListener
    implements Listener {
        private ArenaListener() {
        }

        @EventHandler(ignoreCancelled=true)
        public void on(PlayerInteractEvent event) {
            if (!event.hasBlock() || !ArenaManagerImpl.this.config.isPreventInteract()) {
                return;
            }
            ArenaImpl arena = ArenaManagerImpl.this.get(event.getPlayer());
            if (arena == null || arena.isCountingComplete()) {
                return;
            }
            event.setCancelled(true);
        }

        @EventHandler(ignoreCancelled=true)
        public void on(EntityDamageEvent event) {
            if (!ArenaManagerImpl.this.config.isPreventPvp() || !(event.getEntity() instanceof Player)) {
                return;
            }
            ArenaImpl arena = ArenaManagerImpl.this.get((Player)event.getEntity());
            if (arena == null || arena.isCountingComplete()) {
                return;
            }
            event.setCancelled(true);
        }

        @EventHandler(ignoreCancelled=true)
        public void on(ProjectileLaunchEvent event) {
            if (!ArenaManagerImpl.this.config.isPreventLaunchProjectile()) {
                return;
            }
            ProjectileSource shooter = event.getEntity().getShooter();
            if (!(shooter instanceof Player)) {
                return;
            }
            ArenaImpl arena = ArenaManagerImpl.this.get((Player)shooter);
            if (arena == null || arena.isCountingComplete()) {
                return;
            }
            event.setCancelled(true);
        }

        @EventHandler(ignoreCancelled=true)
        public void on(PlayerMoveEvent event) {
            if (!ArenaManagerImpl.this.config.isPreventMovement()) {
                return;
            }
            Location from = event.getFrom();
            Location to = event.getTo();
            if (from.getBlockX() == to.getBlockX() && from.getBlockY() == to.getBlockY() && from.getBlockZ() == to.getBlockZ()) {
                return;
            }
            ArenaImpl arena = ArenaManagerImpl.this.get(event.getPlayer());
            if (arena == null || arena.isCountingComplete()) {
                return;
            }
            event.setTo(from);
        }
    }
}

