/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.command.commands;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.api.spectate.SpectateManager;
import com.meteordevelopments.duels.arena.ArenaImpl;
import com.meteordevelopments.duels.command.BaseCommand;
import com.meteordevelopments.duels.match.DuelMatch;
import com.meteordevelopments.duels.spectate.SpectatorImpl;
import com.meteordevelopments.duels.util.inventory.InventoryUtil;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SpectateCommand
extends BaseCommand {
    public SpectateCommand(DuelsPlugin plugin) {
        super(plugin, "spectate", "duels.spectate", true);
    }

    @Override
    protected void execute(CommandSender sender, String label, String[] args) {
        Player player = (Player)sender;
        SpectatorImpl spectator = this.spectateManager.get(player);
        if (this.containsPlaceholder(args)) {
            this.lang.sendMessage(sender, "ERROR.command.invalid-argument", "arg", String.join((CharSequence)" ", args));
            return;
        }
        if (spectator != null) {
            this.spectateManager.stopSpectating(player);
            this.lang.sendMessage((CommandSender)player, "COMMAND.spectate.stop-spectate", "name", spectator.getTargetName());
            return;
        }
        if (args.length == 0) {
            this.lang.sendMessage(sender, "COMMAND.spectate.usage", "command", label);
            return;
        }
        if (this.config.isSpecRequiresClearedInventory() && InventoryUtil.hasItem(player)) {
            this.lang.sendMessage(sender, "ERROR.duel.inventory-not-empty", new Object[0]);
            return;
        }
        Player target = Bukkit.getPlayerExact((String)args[0]);
        if (target == null) {
            this.lang.sendMessage(sender, "ERROR.player.not-found", "name", args[0]);
            return;
        }
        SpectateManager.Result result = this.spectateManager.startSpectating(player, target);
        switch (result) {
            case EVENT_CANCELLED: {
                return;
            }
            case IN_MATCH: {
                this.lang.sendMessage((CommandSender)player, "ERROR.duel.already-spectating.sender", new Object[0]);
                return;
            }
            case IN_QUEUE: {
                this.lang.sendMessage((CommandSender)player, "ERROR.duel.already-in-queue", new Object[0]);
            }
            case ALREADY_SPECTATING: {
                this.lang.sendMessage((CommandSender)player, "ERROR.duel.already-in-match.sender", new Object[0]);
                return;
            }
            case TARGET_NOT_IN_MATCH: {
                this.lang.sendMessage((CommandSender)player, "ERROR.duel.not-in-match", "name", target.getName());
                return;
            }
            case SUCCESS: {
                ArenaImpl arena = this.arenaManager.get(target);
                if (arena == null || arena.getMatch() == null) {
                    return;
                }
                DuelMatch match = arena.getMatch();
                String kit = match.getKit() != null ? match.getKit().getName() : this.lang.getMessage("GENERAL.none");
                this.lang.sendMessage((CommandSender)player, "COMMAND.spectate.start-spectate", "name", target.getName(), "opponent", Objects.requireNonNull(arena.getOpponent(target)).getName(), "kit", kit, "arena", arena.getName(), "bet_amount", match.getBet());
            }
        }
    }

    private boolean containsPlaceholder(String[] args) {
        for (String arg : args) {
            if (!arg.contains("%") && !arg.contains("<") && !arg.contains(">")) continue;
            return true;
        }
        return false;
    }
}

