/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.command.commands.duel.subcommands;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.api.user.UserManager;
import com.meteordevelopments.duels.command.BaseCommand;
import com.meteordevelopments.duels.kit.KitImpl;
import com.meteordevelopments.duels.util.StringUtil;
import java.util.List;
import org.bukkit.command.CommandSender;

public class TopCommand
extends BaseCommand {
    public TopCommand(DuelsPlugin plugin) {
        super(plugin, "top", "top [-:kit:wins:losses]", "Displays top wins, losses, or rating for kit.", "duels.top", 2, true, new String[0]);
    }

    @Override
    protected void execute(CommandSender sender, String label, String[] args) {
        List<UserManager.TopData> top;
        UserManager.TopEntry topEntry;
        if (!this.userManager.isLoaded()) {
            this.lang.sendMessage(sender, "ERROR.data.not-loaded", new Object[0]);
            return;
        }
        if (args[1].equals("-")) {
            topEntry = this.userManager.getTopRatings();
        } else if (args[1].equalsIgnoreCase("wins")) {
            topEntry = this.userManager.getWins();
        } else if (args[1].equalsIgnoreCase("losses")) {
            topEntry = this.userManager.getLosses();
        } else {
            String name = StringUtil.join(args, " ", 1, args.length);
            KitImpl kit = this.kitManager.get(name);
            if (kit == null) {
                this.lang.sendMessage(sender, "ERROR.kit.not-found", "name", name);
                return;
            }
            topEntry = this.userManager.getTopRatings(kit);
        }
        if (topEntry == null || (top = topEntry.getData()).isEmpty()) {
            this.lang.sendMessage(sender, "ERROR.top.no-data-available", new Object[0]);
            return;
        }
        this.lang.sendMessage(sender, "COMMAND.duel.top.next-update", "remaining", this.userManager.getNextUpdate(topEntry.getCreation()));
        this.lang.sendMessage(sender, "COMMAND.duel.top.header", "type", topEntry.getType());
        for (int i = 0; i < top.size(); ++i) {
            UserManager.TopData data = top.get(i);
            this.lang.sendMessage(sender, "COMMAND.duel.top.display-format", "rank", i + 1, "name", data.getName(), "score", data.getValue(), "identifier", topEntry.getIdentifier());
        }
        this.lang.sendMessage(sender, "COMMAND.duel.top.footer", "type", topEntry.getType());
    }
}

