/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.command.commands.duels.subcommands;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.command.BaseCommand;
import com.meteordevelopments.duels.kit.KitImpl;
import com.meteordevelopments.duels.queue.Queue;
import com.meteordevelopments.duels.util.BlockUtil;
import com.meteordevelopments.duels.util.NumberUtil;
import com.meteordevelopments.duels.util.StringUtil;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.Sign;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AddsignCommand
extends BaseCommand {
    public AddsignCommand(DuelsPlugin plugin) {
        super(plugin, "addsign", "addsign [queueName] [bet] [size] [kit:-]", "Creates a queue sign with given queue name, bet, team size and kit.", 5, true, new String[0]);
    }

    @Override
    protected void execute(CommandSender sender, String label, String[] args) {
        String kitName;
        Player player = (Player)sender;
        Sign sign = BlockUtil.getTargetBlock(player, Sign.class, 6);
        if (sign == null) {
            this.lang.sendMessage(sender, "ERROR.sign.not-a-sign", new Object[0]);
            return;
        }
        String queueName = args[1];
        int bet = NumberUtil.parseInt(args[2]).orElse(0);
        int size = Math.max(1, NumberUtil.parseInt(args[3]).orElse(1));
        KitImpl kit = null;
        if (!args[4].equals("-") && (kit = this.kitManager.get(kitName = StringUtil.join(args, " ", 4, args.length).replace("-", " "))) == null) {
            this.lang.sendMessage(sender, "ERROR.kit.not-found", "name", kitName);
            return;
        }
        kitName = kit != null ? kit.getName() : this.lang.getMessage("GENERAL.none");
        Queue queue = this.queueManager.getByName(queueName);
        if (queue == null) {
            this.queueManager.create((CommandSender)player, queueName, kit, bet, size);
            queue = this.queueManager.getByName(queueName);
            if (queue == null) {
                this.lang.sendMessage(sender, "ERROR.queue.create-failed", "name", queueName, "kit", kitName, "bet_amount", bet);
                return;
            }
        }
        if (!this.queueSignManager.create(player, sign.getLocation(), queue)) {
            this.lang.sendMessage(sender, "ERROR.sign.already-exists", new Object[0]);
            return;
        }
        Location location = sign.getLocation();
        this.lang.sendMessage(sender, "COMMAND.duels.add-sign", "location", StringUtil.parse(location), "name", queueName, "kit", kitName, "bet_amount", bet);
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 2) {
            return Arrays.asList("Kit_name", "Example_2v2", "Test_3v3", "Any_name_without_spaces");
        }
        if (args.length == 3) {
            return Arrays.asList("0", "10", "50", "100", "500", "1000", "bet_amount");
        }
        if (args.length == 4) {
            return Arrays.asList("1", "2", "3", "4", "5", "upto_infinity_(number_only)");
        }
        if (args.length > 4) {
            return this.handleTabCompletion(args[4], this.kitManager.getNames(true));
        }
        return null;
    }
}

