/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.command.commands.duels.subcommands;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.arena.ArenaImpl;
import com.meteordevelopments.duels.command.BaseCommand;
import com.meteordevelopments.duels.kit.KitImpl;
import com.meteordevelopments.duels.util.StringUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class InfoCommand
extends BaseCommand {
    public InfoCommand(DuelsPlugin plugin) {
        super(plugin, "info", "info [name]", "Displays information about the selected arena.", 2, false, new String[0]);
    }

    @Override
    protected void execute(CommandSender sender, String label, String[] args) {
        String name = StringUtil.join(args, " ", 1, args.length).replace("-", " ");
        ArenaImpl arena = this.arenaManager.get(name);
        if (arena == null) {
            this.lang.sendMessage(sender, "ERROR.arena.not-found", "name", name);
            return;
        }
        String inUse = arena.isUsed() ? this.lang.getMessage("GENERAL.true") : this.lang.getMessage("GENERAL.false");
        String disabled = arena.isDisabled() ? this.lang.getMessage("GENERAL.true") : this.lang.getMessage("GENERAL.false");
        String kits = StringUtil.join(arena.getKits().stream().map(KitImpl::getName).collect(Collectors.toList()), ", ");
        String positions = StringUtil.join(arena.getPositions().values().stream().map(StringUtil::parse).collect(Collectors.toList()), ", ");
        String players = StringUtil.join(arena.getPlayers().stream().map(Player::getName).collect(Collectors.toList()), ", ");
        this.lang.sendMessage(sender, "COMMAND.duels.info", "name", name, "in_use", inUse, "disabled", disabled, "kits", !kits.isEmpty() ? kits : this.lang.getMessage("GENERAL.none"), "positions", !positions.isEmpty() ? positions : this.lang.getMessage("GENERAL.none"), "players", !players.isEmpty() ? players : this.lang.getMessage("GENERAL.none"));
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 2) {
            return this.handleTabCompletion(args[1], this.arenaManager.getNames());
        }
        return null;
    }
}

