/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.command.commands.duels.subcommands;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.command.BaseCommand;
import com.meteordevelopments.duels.util.Loadable;
import com.meteordevelopments.duels.util.Reloadable;
import com.meteordevelopments.duels.util.StringUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class ReloadCommand
extends BaseCommand {
    public ReloadCommand(DuelsPlugin plugin) {
        super(plugin, "reload", null, null, 1, false, "rl");
    }

    @Override
    protected void execute(CommandSender sender, String label, String[] args) {
        if (args.length > this.getLength()) {
            Loadable target = this.plugin.find(args[1]);
            if (!(target instanceof Reloadable)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid module. The following modules are available for a reload: " + StringUtil.join(this.plugin.getReloadables(), ", "));
                return;
            }
            String name = target.getClass().getSimpleName();
            if (this.plugin.reload(target)) {
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "[" + this.plugin.getDescription().getFullName() + "] Successfully reloaded " + name + ".");
            } else {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "An error occured while reloading " + name + "! Please check the console for more information.");
            }
            return;
        }
        if (this.plugin.reload()) {
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "[" + this.plugin.getDescription().getFullName() + "] Reload complete.");
        } else {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "An error occured while reloading the plugin! Please check the console for more information.");
        }
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 2) {
            return this.plugin.getReloadables().stream().filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        return null;
    }
}

