/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.gui.betting;

import com.meteordevelopments.duels-optimised.shaded.morepaperlib.scheduling.ScheduledTask;
import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.duel.DuelManager;
import com.meteordevelopments.duels.gui.betting.buttons.CancelButton;
import com.meteordevelopments.duels.gui.betting.buttons.DetailsButton;
import com.meteordevelopments.duels.gui.betting.buttons.HeadButton;
import com.meteordevelopments.duels.gui.betting.buttons.StateButton;
import com.meteordevelopments.duels.setting.Settings;
import com.meteordevelopments.duels.util.compat.CompatUtil;
import com.meteordevelopments.duels.util.compat.Items;
import com.meteordevelopments.duels.util.gui.AbstractGui;
import com.meteordevelopments.duels.util.gui.Button;
import com.meteordevelopments.duels.util.gui.GuiListener;
import com.meteordevelopments.duels.util.inventory.InventoryBuilder;
import com.meteordevelopments.duels.util.inventory.InventoryUtil;
import com.meteordevelopments.duels.util.inventory.Slots;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class BettingGui
extends AbstractGui<DuelsPlugin> {
    private final Section[] sections = new Section[]{new Section(9, 13, 4), new Section(14, 18, 4)};
    private final GuiListener<DuelsPlugin> guiListener;
    private final DuelManager duelManager;
    private final Settings settings;
    private final Inventory inventory;
    private final UUID sender;
    private final UUID target;
    private boolean firstReady;
    private boolean secondReady;
    private boolean waitDone;
    private boolean cancelWait;

    public BettingGui(DuelsPlugin plugin, Settings settings, Player sender, Player target) {
        super(plugin);
        this.guiListener = plugin.getGuiListener();
        this.duelManager = plugin.getDuelManager();
        this.settings = settings;
        this.inventory = InventoryBuilder.of(plugin.getLang().getMessage("GUI.item-betting.title"), 54).build();
        this.sender = sender.getUniqueId();
        this.target = target.getUniqueId();
        this.set(this.inventory, 13, 14, 5, new CancelButton(plugin));
        Slots.run(0, 3, slot -> this.inventory.setItem(slot.intValue(), Items.ORANGE_PANE.clone()));
        Slots.run(45, 48, slot -> this.inventory.setItem(slot.intValue(), Items.ORANGE_PANE.clone()));
        Slots.run(6, 9, slot -> this.inventory.setItem(slot.intValue(), Items.BLUE_PANE.clone()));
        Slots.run(51, 54, slot -> this.inventory.setItem(slot.intValue(), Items.BLUE_PANE.clone()));
        this.set(this.inventory, 3, new StateButton(plugin, this, sender));
        this.set(this.inventory, 4, new DetailsButton(plugin, settings));
        this.set(this.inventory, 5, new StateButton(plugin, this, target));
        this.set(this.inventory, 48, new HeadButton(plugin, sender));
        this.set(this.inventory, 50, new HeadButton(plugin, target));
    }

    private boolean isFirst(Player player) {
        return player.getUniqueId().equals(this.sender);
    }

    private Section getSection(Player player) {
        return this.isFirst(player) ? this.sections[0] : this.sections[1];
    }

    public boolean isReady(Player player) {
        return this.isFirst(player) ? this.firstReady : this.secondReady;
    }

    public void setReady(Player player) {
        if (this.isFirst(player)) {
            this.firstReady = true;
        } else {
            this.secondReady = true;
        }
        if (this.firstReady && this.secondReady) {
            this.startWaitTask();
        }
    }

    public void update(Player player, Button<DuelsPlugin> button) {
        this.update(player, this.inventory, button);
    }

    @Override
    public void open(Player ... players) {
        for (Player player : players) {
            this.update(player);
            player.openInventory(this.inventory);
        }
    }

    @Override
    public boolean isPart(Inventory inventory) {
        return inventory.equals((Object)this.inventory);
    }

    @Override
    public void on(Player player, Inventory top, InventoryClickEvent event) {
        Inventory clicked = event.getClickedInventory();
        if (clicked == null) {
            return;
        }
        Button button = this.get(this.inventory, event.getSlot());
        if (this.firstReady && this.secondReady && !(button instanceof CancelButton)) {
            event.setCancelled(true);
            return;
        }
        int slot = event.getSlot();
        if (event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY || event.getAction() == InventoryAction.COLLECT_TO_CURSOR) {
            event.setCancelled(true);
            return;
        }
        if (!clicked.equals((Object)top)) {
            return;
        }
        Section section = this.getSection(player);
        if (section == null) {
            return;
        }
        if (!this.isReady(player) && section.isPart(slot)) {
            return;
        }
        event.setCancelled(true);
        if (button == null) {
            return;
        }
        button.onClick(player);
    }

    @Override
    public void on(Player player, Set<Integer> rawSlots, InventoryDragEvent event) {
        Section section = this.getSection(player);
        if (section == null) {
            return;
        }
        boolean in = false;
        boolean out = false;
        boolean outSec = false;
        for (int slot : rawSlots) {
            if (slot > 53) {
                out = true;
                continue;
            }
            if (!section.isPart(slot)) {
                outSec = true;
            }
            in = true;
        }
        if (in && (this.isReady(player) || out || outSec)) {
            event.setCancelled(true);
        }
    }

    @Override
    public void on(Player player, Inventory inventory, InventoryCloseEvent event) {
        if (this.waitDone) {
            return;
        }
        this.cancelWait = true;
        InventoryUtil.addOrDrop(player, this.getSection(player).collect());
        this.guiListener.removeGui(player, this);
        Player other = Bukkit.getPlayer((UUID)(this.sender.equals(player.getUniqueId()) ? this.target : this.sender));
        if (other != null) {
            DuelsPlugin.getMorePaperLib().scheduling().entitySpecificScheduler((Entity)other).run(() -> {
                if (inventory.getViewers().contains(other)) {
                    other.closeInventory();
                }
            }, null);
        }
    }

    @Override
    public void clear() {
        Player first = Bukkit.getPlayer((UUID)this.sender);
        Player second = Bukkit.getPlayer((UUID)this.target);
        if (first != null && second != null) {
            InventoryUtil.addOrDrop(first, this.getSection(first).collect());
            InventoryUtil.addOrDrop(second, this.getSection(second).collect());
        }
        super.clear();
    }

    private void startWaitTask() {
        new WaitTask().startTask();
    }

    private class Section {
        private final int start;
        private final int end;
        private final int height;

        Section(int start, int end, int height) {
            this.start = start;
            this.end = end;
            this.height = height;
        }

        private boolean isPart(int slot) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = this.start; x < this.end; ++x) {
                    if (x + y * 9 != slot) continue;
                    return true;
                }
            }
            return false;
        }

        private List<ItemStack> collect() {
            ArrayList<ItemStack> result = new ArrayList<ItemStack>();
            Slots.run(this.start, this.end, this.height, slot -> {
                ItemStack item = BettingGui.this.inventory.getItem(slot.intValue());
                if (item != null && item.getType() != Material.AIR) {
                    result.add(item);
                    BettingGui.this.inventory.setItem(slot.intValue(), null);
                }
            });
            return result;
        }
    }

    private class WaitTask
    implements Runnable {
        private static final int SLOT_START = 13;
        private ScheduledTask task;
        private int counter;

        private WaitTask() {
        }

        public void startTask() {
            this.task = DuelsPlugin.getMorePaperLib().scheduling().globalRegionalScheduler().runAtFixedRate(this, 10L, 20L);
        }

        @Override
        public void run() {
            if (BettingGui.this.cancelWait) {
                this.task.cancel();
                return;
            }
            if (this.counter < 5) {
                int slot = 13 + 9 * this.counter;
                ItemStack item = BettingGui.this.inventory.getItem(slot);
                if (CompatUtil.isPre1_13()) {
                    item.setDurability((short)5);
                } else {
                    ItemStack greenPane = Items.GREEN_PANE.clone();
                    greenPane.setItemMeta(item.getItemMeta());
                    item = greenPane;
                }
                BettingGui.this.inventory.setItem(slot, item);
                ++this.counter;
                return;
            }
            this.task.cancel();
            BettingGui.this.waitDone = true;
            Player sender = Bukkit.getPlayer((UUID)BettingGui.this.sender);
            Player target = Bukkit.getPlayer((UUID)BettingGui.this.target);
            if (sender == null || target == null) {
                return;
            }
            DuelsPlugin.getMorePaperLib().scheduling().entitySpecificScheduler((Entity)sender).run(() -> ((Player)sender).closeInventory(), () -> {});
            DuelsPlugin.getMorePaperLib().scheduling().entitySpecificScheduler((Entity)target).run(() -> ((Player)target).closeInventory(), () -> {});
            HashMap<UUID, List<ItemStack>> items = new HashMap<UUID, List<ItemStack>>();
            items.put(sender.getUniqueId(), BettingGui.this.getSection(sender).collect());
            items.put(target.getUniqueId(), BettingGui.this.getSection(target).collect());
            BettingGui.this.guiListener.removeGui(sender, BettingGui.this);
            BettingGui.this.guiListener.removeGui(target, BettingGui.this);
            BettingGui.this.duelManager.startMatch(sender, target, BettingGui.this.settings, items, null);
        }
    }
}

