/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.gui.settings.buttons;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.gui.BaseButton;
import com.meteordevelopments.duels.setting.Settings;
import com.meteordevelopments.duels.util.compat.Items;
import com.meteordevelopments.duels.util.inventory.ItemBuilder;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ArenaSelectButton
extends BaseButton {
    public ArenaSelectButton(DuelsPlugin plugin) {
        super(plugin, ItemBuilder.of(Items.EMPTY_MAP).name(plugin.getLang().getMessage("GUI.settings.buttons.arena-selector.name"), plugin.getLang()).build());
    }

    @Override
    public void update(Player player) {
        if (this.config.isArenaSelectingUsePermission() && !player.hasPermission("duels.use.arena-select") && !player.hasPermission("duels.use.*")) {
            this.setLore(this.lang, this.lang.getMessage("GUI.settings.buttons.arena-selector.lore-no-permission").split("\n"));
            return;
        }
        Settings settings = this.settingManager.getSafely(player);
        String arena = settings.getArena() != null ? settings.getArena().getName() : this.lang.getMessage("GENERAL.random");
        String lore = this.lang.getMessage("GUI.settings.buttons.arena-selector.lore", "arena", arena);
        this.setLore(this.lang, lore.split("\n"));
    }

    @Override
    public void onClick(Player player) {
        if (this.config.isArenaSelectingUsePermission() && !player.hasPermission("duels.use.arena-select") && !player.hasPermission("duels.use.*")) {
            this.lang.sendMessage((CommandSender)player, "ERROR.no-permission", "permission", "duels.use.arena-select");
            return;
        }
        this.arenaManager.getGui().open(player);
    }
}

