/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.hook.hooks;

import com.massivecraft.factions.entity.MPlayer;
import com.massivecraft.factions.event.EventFactionsPowerChange;
import com.massivecraft.factions.event.PowerLossEvent;
import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.arena.ArenaManagerImpl;
import com.meteordevelopments.duels.config.Config;
import com.meteordevelopments.duels.util.Log;
import com.meteordevelopments.duels.util.hook.PluginHook;
import com.meteordevelopments.duels.util.reflect.ReflectionUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class FactionsHook
extends PluginHook<DuelsPlugin> {
    public static final String NAME = "Factions";
    private final Config config;
    private final ArenaManagerImpl arenaManager;

    public FactionsHook(DuelsPlugin plugin) {
        super(plugin, NAME);
        this.config = plugin.getConfiguration();
        this.arenaManager = plugin.getArenaManager();
        Object listener = null;
        if (ReflectionUtil.getClassUnsafe("com.massivecraft.factions.event.PowerLossEvent") != null) {
            listener = new FactionsUUIDListener();
        } else if (ReflectionUtil.getClassUnsafe("com.massivecraft.factions.event.EventFactionsPowerChange") != null) {
            listener = new Factions2Listener();
        }
        if (listener == null) {
            Log.error("Could not detect this version of Factions. Please contact the developer if you believe this is an error.");
            return;
        }
        Bukkit.getPluginManager().registerEvents((Listener)listener, (Plugin)plugin);
    }

    public class FactionsUUIDListener
    implements Listener {
        @EventHandler
        public void on(PowerLossEvent event) {
            if (!FactionsHook.this.config.isFuNoPowerLoss()) {
                return;
            }
            Player player = event.getfPlayer().getPlayer();
            if (player == null || !FactionsHook.this.arenaManager.isInMatch(player)) {
                return;
            }
            event.setCancelled(true);
        }
    }

    public class Factions2Listener
    implements Listener {
        @EventHandler
        public void on(EventFactionsPowerChange event) {
            if (!FactionsHook.this.config.isFNoPowerLoss()) {
                return;
            }
            MPlayer mPlayer = event.getMPlayer();
            Player player = mPlayer.getPlayer();
            if (player == null || !FactionsHook.this.arenaManager.isInMatch(player)) {
                return;
            }
            event.setCancelled(true);
        }
    }
}

