/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.hook.hooks;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.util.Log;
import com.meteordevelopments.duels.util.hook.PluginHook;
import java.util.Arrays;
import java.util.Collection;
import lombok.Generated;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultHook
extends PluginHook<DuelsPlugin> {
    public static final String NAME = "Vault";
    private Economy economy;

    public VaultHook(DuelsPlugin plugin) {
        super(plugin, NAME);
        RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(Economy.class);
        if (provider == null) {
            Log.warn("Found no available economy plugin that supports Vault. Money betting will not be available.");
            return;
        }
        this.economy = (Economy)provider.getProvider();
        Log.info("Using Economy Provider: " + this.economy.getClass().getName());
    }

    public boolean has(int amount, Collection<Player> players) {
        if (this.economy == null) {
            return false;
        }
        for (Player player : players) {
            if (this.economy.has((OfflinePlayer)player, (double)amount)) continue;
            return false;
        }
        return true;
    }

    public boolean has(int amount, Player ... players) {
        return this.has(amount, Arrays.asList(players));
    }

    public void add(int amount, Collection<Player> players) {
        if (this.economy != null) {
            players.forEach(player -> this.economy.depositPlayer((OfflinePlayer)player, (double)amount));
        }
    }

    public void add(int amount, Player ... players) {
        this.add(amount, Arrays.asList(players));
    }

    public void remove(int amount, Collection<Player> players) {
        if (this.economy != null) {
            players.forEach(player -> this.economy.withdrawPlayer((OfflinePlayer)player, (double)amount));
        }
    }

    public void remove(int amount, Player ... players) {
        this.remove(amount, Arrays.asList(players));
    }

    @Generated
    public Economy getEconomy() {
        return this.economy;
    }
}

