/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.hook.hooks.worldguard;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.config.Config;
import com.meteordevelopments.duels.hook.hooks.worldguard.WorldGuard6Handler;
import com.meteordevelopments.duels.hook.hooks.worldguard.WorldGuard7Handler;
import com.meteordevelopments.duels.hook.hooks.worldguard.WorldGuardHandler;
import com.meteordevelopments.duels.util.hook.PluginHook;
import com.meteordevelopments.duels.util.reflect.ReflectionUtil;
import java.util.List;
import org.bukkit.entity.Player;

public class WorldGuardHook
extends PluginHook<DuelsPlugin> {
    public static final String NAME = "WorldGuard";
    private final Config config;
    private final WorldGuardHandler handler;

    public WorldGuardHook(DuelsPlugin plugin) {
        super(plugin, NAME);
        this.config = plugin.getConfiguration();
        this.handler = ReflectionUtil.getClassUnsafe("com.sk89q.worldguard.WorldGuard") != null ? new WorldGuard7Handler() : new WorldGuard6Handler();
    }

    public String findDuelZone(Player player) {
        if (!this.config.isDuelzoneEnabled()) {
            return null;
        }
        List<String> allowedRegions = this.config.getDuelzones();
        if (allowedRegions.isEmpty()) {
            return null;
        }
        return this.handler.findRegion(player, allowedRegions);
    }
}

