/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.kit.edit;

import com.google.common.base.Charsets;
import com.meteordevelopments.duels-optimised.shaded.paperlib.PaperLib;
import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.data.KitData;
import com.meteordevelopments.duels.kit.KitImpl;
import com.meteordevelopments.duels.kit.edit.EditSession;
import com.meteordevelopments.duels.util.hook.PluginHook;
import com.meteordevelopments.duels.util.inventory.InventoryUtil;
import com.meteordevelopments.duels.util.json.JsonUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class KitEditManager
extends PluginHook<DuelsPlugin> {
    private static KitEditManager instance;
    private final Map<UUID, EditSession> activeSessions = new HashMap<UUID, EditSession>();
    private final File playerKitsDirectory;

    public KitEditManager(DuelsPlugin plugin) {
        super(plugin, "KitEditManager");
        instance = this;
        this.playerKitsDirectory = new File(plugin.getDataFolder(), "playerkits");
        if (!this.playerKitsDirectory.exists()) {
            this.playerKitsDirectory.mkdirs();
        }
    }

    public boolean startEditSession(Player player, String kitName) {
        UUID playerId = player.getUniqueId();
        if (this.activeSessions.containsKey(playerId)) {
            return false;
        }
        KitImpl kit = ((DuelsPlugin)this.plugin).getKitManager().get(kitName);
        if (kit == null) {
            return false;
        }
        EditSession session = new EditSession(player, kitName);
        this.activeSessions.put(playerId, session);
        PaperLib.teleportAsync((Entity)player, ((DuelsPlugin)this.plugin).getPlayerManager().getKitLobby());
        player.getInventory().clear();
        if (this.hasPlayerKit(player, kitName)) {
            this.loadPlayerKit(player, kitName);
        } else {
            this.loadKitToPlayer(player, kit);
        }
        return true;
    }

    public boolean saveKit(Player player) {
        UUID playerId = player.getUniqueId();
        EditSession session = this.activeSessions.get(playerId);
        if (session == null) {
            return false;
        }
        if (!this.validateKitItems(player, session.getKitName())) {
            ((DuelsPlugin)this.plugin).getLang().sendMessage((CommandSender)player, "KIT.EDIT.invalid-items", new Object[0]);
            this.abortEditSession(player);
            return false;
        }
        try {
            this.savePlayerKit(player, session.getKitName());
            session.restoreInventory(player);
            session.returnToOldLocation(player);
            this.activeSessions.remove(playerId);
            return true;
        }
        catch (IOException e) {
            ((DuelsPlugin)this.plugin).getLogger().severe("Failed to save kit for player " + player.getName() + ": " + e.getMessage());
            return false;
        }
    }

    public boolean abortEditSession(Player player) {
        UUID playerId = player.getUniqueId();
        EditSession session = this.activeSessions.get(playerId);
        if (session == null) {
            return false;
        }
        session.restoreInventory(player);
        session.returnToOldLocation(player);
        this.activeSessions.remove(playerId);
        return true;
    }

    public boolean forceFreshEditSession(Player player, String kitName) {
        if (this.activeSessions.containsKey(player.getUniqueId())) {
            this.abortEditSession(player);
        }
        return this.startEditSession(player, kitName);
    }

    public boolean isEditing(Player player) {
        return this.activeSessions.containsKey(player.getUniqueId());
    }

    public EditSession getEditSession(Player player) {
        return this.activeSessions.get(player.getUniqueId());
    }

    public void handlePlayerQuit(Player player) {
        UUID playerId = player.getUniqueId();
        EditSession session = this.activeSessions.get(playerId);
        if (session != null) {
            ((DuelsPlugin)this.plugin).getLogger().info("Player " + player.getName() + " left during kit editing session. Restoring inventory.");
            session.returnToOldLocation(player);
            session.restoreInventory(player);
            this.activeSessions.remove(playerId);
        }
    }

    private void loadKitToPlayer(Player player, KitImpl kit) {
        player.getInventory().clear();
        InventoryUtil.fillFromMap(player.getInventory(), kit.getItems());
        player.updateInventory();
    }

    private void savePlayerKit(Player player, String kitName) throws IOException {
        UUID playerId = player.getUniqueId();
        File playerDir = new File(this.playerKitsDirectory, playerId.toString());
        if (!playerDir.exists()) {
            playerDir.mkdirs();
        }
        File kitFile = new File(playerDir, kitName + ".json");
        KitImpl kit = new KitImpl((DuelsPlugin)this.plugin, kitName, player.getInventory());
        KitData data = KitData.fromKit(kit);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(kitFile), Charsets.UTF_8);){
            JsonUtil.getObjectWriter().writeValue(writer, (Object)data);
            ((Writer)writer).flush();
        }
    }

    public Map<UUID, EditSession> getActiveSessions() {
        return new HashMap<UUID, EditSession>(this.activeSessions);
    }

    public boolean hasPlayerKit(Player player, String kitName) {
        UUID playerId = player.getUniqueId();
        File playerDir = new File(this.playerKitsDirectory, playerId.toString());
        File kitFile = new File(playerDir, kitName + ".json");
        return kitFile.exists();
    }

    public void checkAndAbortIfInQueueOrMatch(Player player) {
        if (this.isEditing(player) && (((DuelsPlugin)this.plugin).getQueueManager().get(player) != null || ((DuelsPlugin)this.plugin).getArenaManager().isInMatch(player))) {
            this.abortEditSession(player);
            ((DuelsPlugin)this.plugin).getLang().sendMessage((CommandSender)player, "KIT.EDIT.session-aborted", new Object[0]);
        }
    }

    private boolean validateKitItems(Player player, String kitName) {
        try {
            KitImpl defaultKit = ((DuelsPlugin)this.plugin).getKitManager().get(kitName);
            if (defaultKit == null) {
                return false;
            }
            List<ItemStack> defaultItems = this.getAllItemsFromKit(defaultKit);
            List<ItemStack> playerItems = this.getAllItemsFromPlayer(player);
            return this.itemListsMatch(defaultItems, playerItems);
        }
        catch (Exception e) {
            ((DuelsPlugin)this.plugin).getLogger().severe("Error validating kit items for " + player.getName() + ": " + e.getMessage());
            return false;
        }
    }

    private List<ItemStack> getAllItemsFromKit(KitImpl kit) {
        HashMap<Material, Integer> itemCounts = new HashMap<Material, Integer>();
        Map<String, Map<Integer, ItemStack>> kitItems = kit.getItems();
        for (Map.Entry<String, Map<Integer, ItemStack>> entry : kitItems.entrySet()) {
            Map<Integer, ItemStack> slotItems = entry.getValue();
            for (ItemStack item : slotItems.values()) {
                if (item == null || item.getType() == Material.AIR) continue;
                itemCounts.put(item.getType(), itemCounts.getOrDefault(item.getType(), 0) + 1);
            }
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (Map.Entry entry : itemCounts.entrySet()) {
            Material material = (Material)entry.getKey();
            int count = (Integer)entry.getValue();
            items.add(new ItemStack(material, count));
        }
        return items;
    }

    private List<ItemStack> getAllItemsFromPlayer(Player player) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        PlayerInventory inv = player.getInventory();
        for (ItemStack item : inv.getContents()) {
            if (item == null || item.getType() == Material.AIR) continue;
            items.add(item);
        }
        for (ItemStack item : inv.getArmorContents()) {
            if (item == null || item.getType() == Material.AIR) continue;
            items.add(item);
        }
        ItemStack offhand = inv.getItemInOffHand();
        if (offhand.getType() != Material.AIR) {
            items.add(offhand);
        }
        return items;
    }

    private boolean itemListsMatch(List<ItemStack> list1, List<ItemStack> list2) {
        HashSet<Material> defaultTypes = new HashSet<Material>();
        HashSet<Material> playerTypes = new HashSet<Material>();
        for (ItemStack item : list1) {
            if (item == null) continue;
            defaultTypes.add(item.getType());
        }
        for (ItemStack item : list2) {
            if (item == null) continue;
            playerTypes.add(item.getType());
        }
        for (Material playerType : playerTypes) {
            if (defaultTypes.contains(playerType)) continue;
            return false;
        }
        return true;
    }

    private boolean itemsMatch(ItemStack item1, ItemStack item2) {
        if (item1 == null && item2 == null) {
            return true;
        }
        if (item1 == null || item2 == null) {
            return false;
        }
        return item1.getType() == item2.getType();
    }

    public boolean loadPlayerKit(Player player, String kitName) {
        boolean bl;
        UUID playerId = player.getUniqueId();
        File playerDir = new File(this.playerKitsDirectory, playerId.toString());
        File kitFile = new File(playerDir, kitName + ".json");
        if (!kitFile.exists()) {
            return false;
        }
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(kitFile), Charsets.UTF_8);
        try {
            KitData data = JsonUtil.getObjectMapper().readValue((Reader)reader, KitData.class);
            KitImpl kit = data.toKit((DuelsPlugin)this.plugin);
            player.getInventory().clear();
            InventoryUtil.fillFromMap(player.getInventory(), kit.getItems());
            player.updateInventory();
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                ((DuelsPlugin)this.plugin).getLogger().severe("Failed to load player kit " + kitName + " for " + player.getName() + ": " + e.getMessage());
                return false;
            }
        }
        ((Reader)reader).close();
        return bl;
    }

    @Generated
    public static KitEditManager getInstance() {
        return instance;
    }
}

