/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.listeners;

import com.meteordevelopments.duels.DuelsPlugin;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class ExplosionOwnershipListener
implements Listener {
    private static final String OWNER_META = "Duels-Owner";
    private final DuelsPlugin plugin;
    private final Map<UUID, Long> recentCrystalUse = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, Long> recentTntMinecartUse = new ConcurrentHashMap<UUID, Long>();
    private final Map<World, UUID> recentBlockExplosionTrigger = new ConcurrentHashMap<World, UUID>();
    private final Map<World, Long> recentBlockExplosionTime = new ConcurrentHashMap<World, Long>();
    private final Map<World, UUID> recentMinecartExplosionOwner = new ConcurrentHashMap<World, UUID>();
    private final Map<World, Long> recentMinecartExplosionTime = new ConcurrentHashMap<World, Long>();
    private static ExplosionOwnershipListener INSTANCE;

    public ExplosionOwnershipListener(DuelsPlugin plugin) {
        INSTANCE = this;
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Material type;
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item != null) {
            if (item.getType() == Material.END_CRYSTAL) {
                this.recentCrystalUse.put(player.getUniqueId(), System.currentTimeMillis());
            } else if (item.getType() == Material.TNT_MINECART) {
                this.recentTntMinecartUse.put(player.getUniqueId(), System.currentTimeMillis());
            }
        }
        if (event.getClickedBlock() != null && ((type = event.getClickedBlock().getType()) == Material.RESPAWN_ANCHOR || type.name().endsWith("_BED"))) {
            this.recentBlockExplosionTrigger.put(player.getWorld(), player.getUniqueId());
            this.recentBlockExplosionTime.put(player.getWorld(), System.currentTimeMillis());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntitySpawn(EntitySpawnEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof EnderCrystal)) {
            ExplosiveMinecart minecart;
            Player owner;
            Entity entity2 = event.getEntity();
            if (entity2 instanceof ExplosiveMinecart && (owner = this.findRecentUser((minecart = (ExplosiveMinecart)entity2).getWorld(), this.recentTntMinecartUse)) != null) {
                minecart.setMetadata(OWNER_META, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)owner.getUniqueId().toString()));
            }
            return;
        }
        EnderCrystal crystal = (EnderCrystal)entity;
        Player owner = this.findRecentUser(crystal.getWorld(), this.recentCrystalUse);
        if (owner != null) {
            crystal.setMetadata(OWNER_META, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)owner.getUniqueId().toString()));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVehicleCreate(VehicleCreateEvent event) {
        ExplosiveMinecart minecart;
        Player owner;
        Vehicle vehicle = event.getVehicle();
        if (vehicle instanceof ExplosiveMinecart && (owner = this.findRecentUser((minecart = (ExplosiveMinecart)vehicle).getWorld(), this.recentTntMinecartUse)) != null) {
            minecart.setMetadata(OWNER_META, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)owner.getUniqueId().toString()));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent event) {
        Player recentUser;
        Entity entity = event.getEntity();
        if (!(entity instanceof ExplosiveMinecart)) {
            return;
        }
        ExplosiveMinecart minecart = (ExplosiveMinecart)entity;
        UUID ownerUuid = ExplosionOwnershipListener.getTntMinecartOwner(minecart);
        if (ownerUuid == null && (recentUser = this.findRecentUser(minecart.getWorld(), this.recentTntMinecartUse)) != null) {
            ownerUuid = recentUser.getUniqueId();
        }
        if (ownerUuid != null) {
            World world = minecart.getWorld();
            this.recentMinecartExplosionOwner.put(world, ownerUuid);
            this.recentMinecartExplosionTime.put(world, System.currentTimeMillis());
        }
    }

    private Player findRecentUser(World world, Map<UUID, Long> activityMap) {
        long now = System.currentTimeMillis();
        for (Player p : world.getPlayers()) {
            Long lastUse = activityMap.get(p.getUniqueId());
            if (lastUse == null || now - lastUse > 1500L) continue;
            return p;
        }
        return null;
    }

    public static UUID getCrystalOwner(EnderCrystal crystal) {
        if (crystal.hasMetadata(OWNER_META)) {
            try {
                String uuidStr = ((MetadataValue)crystal.getMetadata(OWNER_META).getFirst()).asString();
                return UUID.fromString(uuidStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static UUID getTntMinecartOwner(ExplosiveMinecart minecart) {
        if (minecart.hasMetadata(OWNER_META)) {
            try {
                String uuidStr = ((MetadataValue)minecart.getMetadata(OWNER_META).getFirst()).asString();
                return UUID.fromString(uuidStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static UUID getRecentBlockExplosionTrigger(World world) {
        return world == null ? null : ExplosionOwnershipListener.INSTANCE.recentBlockExplosionTrigger.get(world);
    }

    public static boolean isRecentBlockExplosionInWorld(World world, long windowMs) {
        if (world == null) {
            return false;
        }
        Long time = ExplosionOwnershipListener.INSTANCE.recentBlockExplosionTime.get(world);
        return time != null && System.currentTimeMillis() - time <= windowMs;
    }

    public static UUID getRecentMinecartExplosionOwner(World world) {
        return world == null ? null : ExplosionOwnershipListener.INSTANCE.recentMinecartExplosionOwner.get(world);
    }

    public static boolean isRecentMinecartExplosionInWorld(World world, long windowMs) {
        if (world == null) {
            return false;
        }
        Long time = ExplosionOwnershipListener.INSTANCE.recentMinecartExplosionTime.get(world);
        return time != null && System.currentTimeMillis() - time <= windowMs;
    }
}

