/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.listeners;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.api.event.match.MatchEndEvent;
import com.meteordevelopments.duels.api.event.match.MatchStartEvent;
import com.meteordevelopments.duels.arena.ArenaImpl;
import com.meteordevelopments.duels.arena.ArenaManagerImpl;
import com.meteordevelopments.duels.config.Config;
import com.meteordevelopments.duels.countdown.DuelCountdown;
import com.meteordevelopments.duels.duel.DuelManager;
import com.meteordevelopments.duels.kit.KitImpl;
import com.meteordevelopments.duels.match.DuelMatch;
import com.meteordevelopments.duels.util.PlayerUtil;
import com.meteordevelopments.duels.util.compat.CompatUtil;
import com.meteordevelopments.duels.util.compat.Items;
import com.meteordevelopments.duels.util.metadata.MetadataUtil;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class KitOptionsListener
implements Listener {
    private static final String METADATA_KEY = "Duels-MaxNoDamageTicks";
    private final DuelsPlugin plugin;
    private final Config config;
    private final ArenaManagerImpl arenaManager;
    private final DuelManager duelManager;

    public KitOptionsListener(DuelsPlugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfiguration();
        this.arenaManager = plugin.getArenaManager();
        this.duelManager = plugin.getDuelManager();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        Bukkit.getPluginManager().registerEvents((Listener)(CompatUtil.isPre1_14() ? new ComboPre1_14Listener() : new ComboPost1_14Listener()), (Plugin)plugin);
    }

    private boolean isEnabled(ArenaImpl arena, KitImpl.Characteristic characteristic) {
        DuelMatch match = arena.getMatch();
        return match != null && match.getKit() != null && match.getKit().hasCharacteristic(characteristic);
    }

    @EventHandler
    public void on(EntityDamageEvent event) {
        double finalHealth;
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ArenaImpl arena = this.arenaManager.get(player);
        if (arena == null) {
            return;
        }
        DuelMatch match = arena.getMatch();
        if (match == null) {
            return;
        }
        if (this.isEnabled(arena, KitImpl.Characteristic.ROUNDS3) && (finalHealth = player.getHealth() - event.getFinalDamage()) <= 0.0) {
            event.setCancelled(true);
            Player winner = match.getAlivePlayers().stream().filter(p -> !p.equals((Object)player)).findFirst().orElse(null);
            if (winner != null) {
                match.addRoundWin(winner);
                if (match.hasWonMatch(winner)) {
                    match.markAsDead(player);
                    double winnerHealth = Math.ceil(winner.getHealth()) * 0.5;
                    arena.broadcast(this.plugin.getLang().getMessage("DUEL.on-death.with-killer", "name", player.getName(), "killer", winner.getName(), "health", winnerHealth));
                    this.duelManager.handleMatchEnd(match, arena, player, player.getLocation(), winner);
                    return;
                }
                event.setDamage(0.0);
                player.setHealth(player.getMaxHealth());
                match.nextRound();
                for (Player p2 : match.getAllPlayers()) {
                    PlayerUtil.reset(p2);
                    p2.setHealth(p2.getMaxHealth());
                    p2.setNoDamageTicks(40);
                    if (match.getKit() == null) continue;
                    match.getKit().equip(p2);
                }
                Player[] players = match.getAllPlayers().toArray(new Player[0]);
                if (players.length >= 2) {
                    this.plugin.getTeleport().tryTeleport(players[0], arena.getPosition(1));
                    this.plugin.getTeleport().tryTeleport(players[1], arena.getPosition(2));
                }
                arena.broadcast(this.plugin.getLang().getMessage("DUEL.rounds.round-end", "round", match.getCurrentRound() - 1, "winner", winner.getName()));
                arena.broadcast(this.plugin.getLang().getMessage("DUEL.rounds.round-status", "player1", players[0].getName(), "wins1", match.getRoundWins(players[0]), "player2", players[1].getName(), "wins2", match.getRoundWins(players[1])));
                if (match.getRoundWins(winner) == 1) {
                    arena.broadcast(this.plugin.getLang().getMessage("DUEL.rounds.match-point", "player", winner.getName()));
                }
                arena.broadcast(this.plugin.getLang().getMessage("DUEL.rounds.round-start", "round", match.getCurrentRound()));
                DuelCountdown countdown = new DuelCountdown(this.plugin, arena, match);
                arena.setCountdown(countdown);
                countdown.startCountdown(0L, 20L);
            }
            return;
        }
        if (!this.isEnabled(arena, KitImpl.Characteristic.SUMO) && !this.isEnabled(arena, KitImpl.Characteristic.BOXING)) {
            return;
        }
        event.setDamage(0.0);
    }

    @EventHandler
    public void on(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ArenaImpl arena = this.arenaManager.get(player);
        if (arena == null || !this.isEnabled(arena, KitImpl.Characteristic.LOKA)) {
            return;
        }
        double originalDamage = event.getDamage();
        double increaseDamage = originalDamage * 1.33;
        event.setDamage(increaseDamage);
    }

    @EventHandler
    public void on(FoodLevelChangeEvent event) {
        HumanEntity humanEntity = event.getEntity();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        ArenaImpl arena = this.arenaManager.get(player);
        if (arena == null || !this.isEnabled(arena, KitImpl.Characteristic.HUNGER)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void on(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        ArenaImpl arena = this.arenaManager.get(player);
        if (player.isDead() || arena == null || !this.isEnabled(arena, KitImpl.Characteristic.SUMO) || arena.isEndGame()) {
            return;
        }
        Location to = event.getTo();
        Location from = event.getFrom();
        if ((from.getBlockX() != to.getBlockX() || from.getBlockY() != to.getBlockY() || from.getBlockZ() != to.getBlockZ()) && arena.getCountdown() != null) {
            from.setPitch(player.getLocation().getPitch());
            from.setYaw(player.getLocation().getYaw());
            event.setTo(from);
            return;
        }
        Block block = event.getFrom().getBlock();
        if (!block.getType().name().contains("WATER") && !block.getType().name().contains("LAVA")) {
            return;
        }
        player.setHealth(0.0);
    }

    @EventHandler
    public void on(PlayerInteractEvent event) {
        ItemStack bowl;
        if (!event.hasItem() || !event.getAction().name().contains("RIGHT")) {
            return;
        }
        Player player = event.getPlayer();
        ArenaImpl arena = this.arenaManager.get(player);
        if (arena == null || !this.isEnabled(arena, KitImpl.Characteristic.SOUP)) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null || item.getType() != Items.MUSHROOM_SOUP) {
            return;
        }
        event.setUseItemInHand(Event.Result.DENY);
        if (this.config.isSoupCancelIfAlreadyFull() && player.getHealth() == PlayerUtil.getMaxHealth(player)) {
            return;
        }
        ItemStack itemStack = bowl = this.config.isSoupRemoveEmptyBowl() ? null : new ItemStack(Material.BOWL);
        if (CompatUtil.isPre1_10()) {
            player.getInventory().setItem(player.getInventory().getHeldItemSlot(), bowl);
        } else if (event.getHand() == EquipmentSlot.OFF_HAND) {
            player.getInventory().setItemInOffHand(bowl);
        } else {
            player.getInventory().setItemInMainHand(bowl);
        }
        double regen = this.config.getSoupHeartsToRegen() * 2.0;
        double oldHealth = player.getHealth();
        double maxHealth = PlayerUtil.getMaxHealth(player);
        player.setHealth(Math.min(oldHealth + regen, maxHealth));
    }

    @EventHandler(ignoreCancelled=true)
    public void on(EntityRegainHealthEvent event) {
        Player player;
        block5: {
            block4: {
                Entity entity = event.getEntity();
                if (!(entity instanceof Player)) break block4;
                player = (Player)entity;
                if (event.getRegainReason() == EntityRegainHealthEvent.RegainReason.SATIATED || event.getRegainReason() == EntityRegainHealthEvent.RegainReason.REGEN) break block5;
            }
            return;
        }
        ArenaImpl arena = this.arenaManager.get(player);
        if (arena == null || !this.isEnabled(arena, KitImpl.Characteristic.UHC)) {
            return;
        }
        event.setCancelled(true);
    }

    private class ComboPre1_14Listener
    implements Listener {
        private ComboPre1_14Listener() {
        }

        @EventHandler
        public void on(MatchStartEvent event) {
            ArenaImpl arena = KitOptionsListener.this.arenaManager.get(event.getMatch().getArena().getName());
            if (arena == null || !KitOptionsListener.this.isEnabled(arena, KitImpl.Characteristic.COMBO)) {
                return;
            }
            for (Player player : event.getPlayers()) {
                MetadataUtil.put(KitOptionsListener.this.plugin, (Entity)player, KitOptionsListener.METADATA_KEY, player.getMaximumNoDamageTicks());
                player.setMaximumNoDamageTicks(0);
            }
        }

        @EventHandler
        public void on(MatchEndEvent event) {
            ArenaImpl arena = KitOptionsListener.this.arenaManager.get(event.getMatch().getArena().getName());
            if (arena == null || !KitOptionsListener.this.isEnabled(arena, KitImpl.Characteristic.COMBO)) {
                return;
            }
            DuelMatch match = arena.getMatch();
            if (match == null) {
                return;
            }
            match.getAllPlayers().forEach(player -> {
                Object value = MetadataUtil.removeAndGet(KitOptionsListener.this.plugin, (Entity)player, KitOptionsListener.METADATA_KEY);
                if (value == null) {
                    return;
                }
                player.setMaximumNoDamageTicks(((Integer)value).intValue());
            });
        }
    }

    private class ComboPost1_14Listener
    implements Listener {
        private ComboPost1_14Listener() {
        }

        @EventHandler
        public void on(EntityDamageByEntityEvent event) {
            boolean isCritical;
            Entity entity = event.getEntity();
            if (!(entity instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            ArenaImpl arena = KitOptionsListener.this.arenaManager.get(player);
            if (arena == null || !KitOptionsListener.this.isEnabled(arena, KitImpl.Characteristic.COMBO)) {
                return;
            }
            boolean bl = isCritical = !player.isOnGround() && !player.isSneaking() && player.getFallDistance() > 0.0f;
            if (isCritical) {
                event.setDamage(event.getDamage() / 1.5);
            }
            KitOptionsListener.this.plugin.doSyncAfter(() -> player.setNoDamageTicks(0), 1L);
        }
    }
}

