/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.listeners;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.arena.ArenaManagerImpl;
import com.meteordevelopments.duels.config.Config;
import com.meteordevelopments.duels.config.Lang;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;

public class ProjectileHitListener
implements Listener {
    private final Config config;
    private final Lang lang;
    private final ArenaManagerImpl arenaManager;

    public ProjectileHitListener(DuelsPlugin plugin) {
        this.config = plugin.getConfiguration();
        this.lang = plugin.getLang();
        this.arenaManager = plugin.getArenaManager();
        if (plugin.getConfiguration().isProjectileHitMessageEnabled()) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        Entity damager = event.getDamager();
        if (!(damager instanceof Projectile) || !this.config.getProjectileHitMessageTypes().contains(damager.getType().name())) {
            return;
        }
        ProjectileSource source = ((Projectile)damager).getShooter();
        if (!(source instanceof Player)) {
            return;
        }
        Player player = (Player)source;
        if (!this.arenaManager.isInMatch(player)) {
            return;
        }
        double health = Math.max(Math.ceil(entity2.getHealth() - event.getFinalDamage()) * 0.5, 0.0);
        this.lang.sendMessage((CommandSender)player, "DUEL.projectile-hit-message", "name", entity2.getName(), "health", health);
    }
}

