/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.listeners;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.arena.ArenaImpl;
import com.meteordevelopments.duels.arena.ArenaManagerImpl;
import com.meteordevelopments.duels.config.Lang;
import com.meteordevelopments.duels.listeners.ExplosionOwnershipListener;
import com.meteordevelopments.duels.match.DuelMatch;
import com.meteordevelopments.duels.match.team.TeamDuelMatch;
import com.meteordevelopments.duels.util.EventUtil;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;

public class TeamDamageListener
implements Listener {
    private final ArenaManagerImpl arenaManager;
    private final Lang lang;

    public TeamDamageListener(DuelsPlugin plugin) {
        this.arenaManager = plugin.getArenaManager();
        if (!plugin.getConfiguration().isForceAllowCombat()) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        }
        this.lang = plugin.getLang();
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onTeamDamage(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player damaged = (Player)entity;
        Player damager = EventUtil.getDamager(event);
        if (damager == null) {
            return;
        }
        ArenaImpl arena = this.arenaManager.get(damaged);
        if (arena == null || !this.arenaManager.isInMatch(damager)) {
            return;
        }
        DuelMatch duelMatch = arena.getMatch();
        if (!(duelMatch instanceof TeamDuelMatch)) {
            return;
        }
        TeamDuelMatch teamMatch = (TeamDuelMatch)duelMatch;
        TeamDuelMatch.Team damagerTeam = teamMatch.getPlayerToTeam().get(damager);
        TeamDuelMatch.Team damagedTeam = teamMatch.getPlayerToTeam().get(damaged);
        if (damagerTeam != null && damagerTeam.equals(damagedTeam)) {
            event.setCancelled(true);
            this.lang.sendMessage((CommandSender)damager, "ERROR.party.cannot-friendly-fire", "name", damaged.getName());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onTeamMinecartDirectDamage(EntityDamageByEntityEvent event) {
        DuelMatch duelMatch;
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player damaged = (Player)entity;
        Entity entity2 = event.getDamager();
        if (!(entity2 instanceof ExplosiveMinecart)) {
            return;
        }
        ExplosiveMinecart minecart = (ExplosiveMinecart)entity2;
        ArenaImpl arena = this.arenaManager.get(damaged);
        if (arena == null || !((duelMatch = arena.getMatch()) instanceof TeamDuelMatch)) {
            return;
        }
        TeamDuelMatch teamMatch = (TeamDuelMatch)duelMatch;
        UUID ownerUuid = ExplosionOwnershipListener.getTntMinecartOwner(minecart);
        if (ownerUuid == null && ExplosionOwnershipListener.isRecentMinecartExplosionInWorld(damaged.getWorld(), 2000L)) {
            ownerUuid = ExplosionOwnershipListener.getRecentMinecartExplosionOwner(damaged.getWorld());
        }
        if (ownerUuid == null) {
            return;
        }
        Player owner = damaged.getServer().getPlayer(ownerUuid);
        if (owner == null || !this.arenaManager.isInMatch(owner)) {
            return;
        }
        TeamDuelMatch.Team damagerTeam = teamMatch.getPlayerToTeam().get(owner);
        TeamDuelMatch.Team damagedTeam = teamMatch.getPlayerToTeam().get(damaged);
        if (damagerTeam != null && damagerTeam.equals(damagedTeam)) {
            event.setCancelled(true);
            this.lang.sendMessage((CommandSender)owner, "ERROR.party.cannot-friendly-fire", "name", damaged.getName());
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onTeamBlockExplosion(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (event.getCause() != EntityDamageEvent.DamageCause.BLOCK_EXPLOSION) {
            return;
        }
        ArenaImpl arena = this.arenaManager.get(player);
        if (arena == null) {
            return;
        }
        if (!ExplosionOwnershipListener.isRecentBlockExplosionInWorld(player.getWorld(), 1500L)) {
            return;
        }
        UUID trigger = ExplosionOwnershipListener.getRecentBlockExplosionTrigger(player.getWorld());
        if (trigger == null) {
            return;
        }
        Player damager = player.getServer().getPlayer(trigger);
        if (damager == null || !this.arenaManager.isInMatch(damager)) {
            return;
        }
        DuelMatch duelMatch = arena.getMatch();
        if (!(duelMatch instanceof TeamDuelMatch)) {
            return;
        }
        TeamDuelMatch teamMatch = (TeamDuelMatch)duelMatch;
        TeamDuelMatch.Team damagerTeam = teamMatch.getPlayerToTeam().get(damager);
        TeamDuelMatch.Team damagedTeam = teamMatch.getPlayerToTeam().get(player);
        if (damagerTeam != null && damagerTeam.equals(damagedTeam)) {
            event.setCancelled(true);
            this.lang.sendMessage((CommandSender)damager, "ERROR.party.cannot-friendly-fire", "name", player.getName());
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onTeamEntityExplosion(EntityDamageEvent event) {
        DuelMatch duelMatch;
        if (event.getCause() != EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player damaged = (Player)entity;
        ArenaImpl arena = this.arenaManager.get(damaged);
        if (arena == null || !((duelMatch = arena.getMatch()) instanceof TeamDuelMatch)) {
            return;
        }
        TeamDuelMatch teamMatch = (TeamDuelMatch)duelMatch;
        if (!ExplosionOwnershipListener.isRecentMinecartExplosionInWorld(damaged.getWorld(), 2000L)) {
            return;
        }
        UUID ownerUuid = ExplosionOwnershipListener.getRecentMinecartExplosionOwner(damaged.getWorld());
        if (ownerUuid == null) {
            return;
        }
        Player owner = damaged.getServer().getPlayer(ownerUuid);
        if (owner == null || !this.arenaManager.isInMatch(owner)) {
            return;
        }
        TeamDuelMatch.Team damagerTeam = teamMatch.getPlayerToTeam().get(owner);
        TeamDuelMatch.Team damagedTeam = teamMatch.getPlayerToTeam().get(damaged);
        if (damagerTeam != null && damagerTeam.equals(damagedTeam)) {
            event.setCancelled(true);
            this.lang.sendMessage((CommandSender)owner, "ERROR.party.cannot-friendly-fire", "name", damaged.getName());
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onTeamPotionSplash(PotionSplashEvent event) {
        DuelMatch duelMatch;
        ThrownPotion potion = event.getPotion();
        ProjectileSource projectileSource = potion.getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player thrower = (Player)projectileSource;
        ArenaImpl arena = this.arenaManager.get(thrower);
        if (arena == null || !((duelMatch = arena.getMatch()) instanceof TeamDuelMatch)) {
            return;
        }
        TeamDuelMatch teamMatch = (TeamDuelMatch)duelMatch;
        TeamDuelMatch.Team throwerTeam = teamMatch.getPlayerToTeam().get(thrower);
        if (throwerTeam == null) {
            return;
        }
        boolean hasHarmfulEffect = false;
        for (PotionEffect effect : potion.getEffects()) {
            PotionEffectType type = effect.getType();
            if (!type.equals((Object)PotionEffectType.POISON) && !type.equals((Object)PotionEffectType.HARM) && !type.equals((Object)PotionEffectType.WITHER) && !type.equals((Object)PotionEffectType.WEAKNESS) && !type.equals((Object)PotionEffectType.SLOW) && !type.equals((Object)PotionEffectType.SLOW_DIGGING) && !type.equals((Object)PotionEffectType.BLINDNESS) && !type.equals((Object)PotionEffectType.CONFUSION) && !type.equals((Object)PotionEffectType.HUNGER) && !type.equals((Object)PotionEffectType.LEVITATION) && !type.equals((Object)PotionEffectType.UNLUCK) && !type.equals((Object)PotionEffectType.BAD_OMEN) && !type.equals((Object)PotionEffectType.DARKNESS)) continue;
            hasHarmfulEffect = true;
            break;
        }
        if (!hasHarmfulEffect) {
            return;
        }
        for (LivingEntity entity : event.getAffectedEntities()) {
            if (!(entity instanceof Player)) continue;
            Player affected = (Player)entity;
            TeamDuelMatch.Team affectedTeam = teamMatch.getPlayerToTeam().get(affected);
            if (affectedTeam == null || !affectedTeam.equals(throwerTeam)) continue;
            event.setIntensity(entity, 0.0);
            this.lang.sendMessage((CommandSender)thrower, "ERROR.party.cannot-friendly-fire", "name", affected.getName());
        }
    }
}

