/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.logging;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.util.DateUtil;
import com.meteordevelopments.duels.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import lombok.Generated;

public class LogManager
implements Log.LogSource {
    private final Logger logger = Logger.getAnonymousLogger();
    private final FileHandler handler;

    public LogManager(DuelsPlugin plugin) throws IOException {
        File folder;
        File pluginFolder = plugin.getDataFolder();
        if (!pluginFolder.exists()) {
            pluginFolder.mkdir();
        }
        if (!(folder = new File(pluginFolder, "logs")).exists()) {
            folder.mkdir();
        }
        this.logger.setLevel(Level.ALL);
        this.logger.setUseParentHandlers(false);
        File file = new File(folder, DateUtil.formatDate(new Date()) + ".log");
        if (!file.exists()) {
            file.createNewFile();
        }
        this.handler = new FileHandler(file.getCanonicalPath(), true);
        this.handler.setLevel(Level.ALL);
        this.handler.setFormatter(new Formatter(this){

            @Override
            public String format(LogRecord record) {
                String thrown = "";
                if (record.getThrown() != null) {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    record.getThrown().printStackTrace(printWriter);
                    printWriter.close();
                    thrown = stringWriter.toString();
                }
                return "[" + DateUtil.formatDatetime(record.getMillis()) + "] [" + record.getLevel().getName() + "] " + record.getMessage() + "\n" + thrown;
            }
        });
        this.logger.addHandler(this.handler);
    }

    public void handleDisable() {
        this.handler.close();
        this.logger.removeHandler(this.handler);
    }

    public void debug(String s) {
        this.log(Level.INFO, "[DEBUG] " + s);
    }

    @Override
    public void log(Level level, String s) {
        this.log(level, s, null);
    }

    @Override
    public void log(Level level, String s, Throwable thrown) {
        if (this.handler == null) {
            return;
        }
        if (thrown != null) {
            this.getLogger().log(level, s, thrown);
        } else {
            this.getLogger().log(level, s);
        }
    }

    @Generated
    public Logger getLogger() {
        return this.logger;
    }
}

