/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.match;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.api.match.Match;
import com.meteordevelopments.duels.arena.ArenaImpl;
import com.meteordevelopments.duels.kit.KitImpl;
import com.meteordevelopments.duels.party.PartyManagerImpl;
import com.meteordevelopments.duels.queue.Queue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class DuelMatch
implements Match {
    protected final PartyManagerImpl partyManager;
    private final long creation;
    private final ArenaImpl arena;
    private final KitImpl kit;
    private final Map<UUID, List<ItemStack>> items;
    private final int bet;
    private final Queue source;
    private boolean finished;
    private int currentRound = 0;
    private final Map<Player, Integer> roundWins = new HashMap<Player, Integer>();
    public HashMap<Location, BlockData> brokenBlocks = new HashMap();
    public List<Block> placedBlocks = new ArrayList<Block>();
    public List<Block> liquids = new ArrayList<Block>();
    public List<Entity> placedEntities = new ArrayList<Entity>();
    public List<Item> droppedItems = new ArrayList<Item>();
    private final Map<Player, Boolean> players = new HashMap<Player, Boolean>();

    public DuelMatch(DuelsPlugin plugin, ArenaImpl arena, KitImpl kit, Map<UUID, List<ItemStack>> items, int bet, Queue source) {
        this.partyManager = plugin.getPartyManager();
        this.creation = System.currentTimeMillis();
        this.arena = arena;
        this.kit = kit;
        this.items = items;
        this.bet = bet;
        this.source = source;
    }

    public long getDurationInMillis() {
        return System.currentTimeMillis() - this.creation;
    }

    public boolean isFromQueue() {
        return this.source != null;
    }

    public boolean isOwnInventory() {
        return this.kit == null;
    }

    public void setFinished() {
        this.finished = true;
    }

    public void addPlayer(Player player) {
        this.players.put(player, false);
    }

    public void markAsDead(Player player) {
        if (this.players.containsKey(player)) {
            this.players.put(player, true);
        }
    }

    public boolean isDead(Player player) {
        return this.players.getOrDefault(player, true);
    }

    public Set<Player> getAlivePlayers() {
        return this.players.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Set<Player> getAllPlayers() {
        return this.players.keySet();
    }

    public int size() {
        return this.getAlivePlayers().size();
    }

    public List<ItemStack> getItems() {
        return this.items != null ? this.items.values().stream().flatMap(Collection::stream).collect(Collectors.toList()) : Collections.emptyList();
    }

    @Override
    @NotNull
    public List<ItemStack> getItems(@NotNull Player player) {
        Objects.requireNonNull(player, "player");
        if (this.items == null) {
            return Collections.emptyList();
        }
        List<ItemStack> items = this.items.get(player.getUniqueId());
        return items != null ? items : Collections.emptyList();
    }

    @Override
    @NotNull
    public Set<Player> getPlayers() {
        return Collections.unmodifiableSet(this.getAlivePlayers());
    }

    @Override
    @NotNull
    public Set<Player> getStartingPlayers() {
        return Collections.unmodifiableSet(this.getAllPlayers());
    }

    @Override
    public long getStart() {
        return this.creation;
    }

    public int getRoundWins(Player player) {
        return this.roundWins.getOrDefault(player, 0);
    }

    public void addRoundWin(Player player) {
        this.roundWins.put(player, this.getRoundWins(player) + 1);
    }

    public boolean hasWonMatch(Player player) {
        return this.getRoundWins(player) >= 2;
    }

    public void nextRound() {
        ++this.currentRound;
        this.players.replaceAll((p, v) -> false);
    }

    public void handleMatchEnd(Player winner, Player loser) {
        this.markAsDead(loser);
        winner.setHealth(winner.getMaxHealth());
        winner.setFireTicks(0);
        winner.setFallDistance(0.0f);
        winner.setVelocity(new Vector(0, 0, 0));
        this.setFinished();
    }

    @Generated
    public long getCreation() {
        return this.creation;
    }

    @Override
    @Generated
    public ArenaImpl getArena() {
        return this.arena;
    }

    @Override
    @Generated
    public KitImpl getKit() {
        return this.kit;
    }

    @Override
    @Generated
    public int getBet() {
        return this.bet;
    }

    @Generated
    public Queue getSource() {
        return this.source;
    }

    @Override
    @Generated
    public boolean isFinished() {
        return this.finished;
    }

    @Generated
    public int getCurrentRound() {
        return this.currentRound;
    }
}

