/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.party;

import com.meteordevelopments.duels.party.PartyMember;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.entity.Player;

public class Party {
    private final long creation;
    private boolean friendlyFire;
    private boolean removed;
    private PartyMember owner;
    private final Map<UUID, PartyMember> members = new HashMap<UUID, PartyMember>();

    public Party(Player owner) {
        this.creation = System.currentTimeMillis();
        this.add(owner);
        this.owner = this.get(owner);
    }

    public PartyMember get(String name) {
        return this.members.values().stream().filter(member -> member.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public PartyMember get(Player player) {
        return this.members.get(player.getUniqueId());
    }

    public boolean isMember(Player player) {
        return this.get(player) != null;
    }

    public boolean add(Player player) {
        PartyMember member = this.get(player);
        if (member != null) {
            return false;
        }
        this.members.put(player.getUniqueId(), new PartyMember(player, this));
        return true;
    }

    public boolean remove(PartyMember member) {
        return this.members.remove(member.getUuid()) != null;
    }

    public boolean remove(Player player) {
        return this.members.remove(player.getUniqueId()) != null;
    }

    public boolean isOwner(Player player) {
        return this.owner != null && this.owner.equals(this.get(player));
    }

    public void setOwner(Player other) {
        PartyMember member = this.get(other);
        if (member == null) {
            return;
        }
        this.owner = member;
    }

    public int size() {
        return this.members.size();
    }

    public Collection<PartyMember> getMembers() {
        return this.members.values();
    }

    public List<Player> getOnlineMembers() {
        return this.members.values().stream().map(PartyMember::getPlayer).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Generated
    public long getCreation() {
        return this.creation;
    }

    @Generated
    public boolean isFriendlyFire() {
        return this.friendlyFire;
    }

    @Generated
    public void setFriendlyFire(boolean friendlyFire) {
        this.friendlyFire = friendlyFire;
    }

    @Generated
    public boolean isRemoved() {
        return this.removed;
    }

    @Generated
    void setRemoved(boolean removed) {
        this.removed = removed;
    }

    @Generated
    public PartyMember getOwner() {
        return this.owner;
    }
}

