/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.player;

import com.google.common.collect.Lists;
import com.meteordevelopments.duels.util.PlayerUtil;
import com.meteordevelopments.duels.util.inventory.InventoryUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;

public class PlayerInfo {
    private final Map<String, Map<Integer, ItemStack>> items = new HashMap<String, Map<Integer, ItemStack>>();
    private final List<PotionEffect> effects;
    private final double health;
    private final float experience;
    private final int level;
    private final int hunger;
    private final boolean restoreExperience;
    private final List<ItemStack> extra = new ArrayList<ItemStack>();
    private Location location;

    public PlayerInfo(List<PotionEffect> effects, double health, float experience, int level, int hunger, Location location, boolean restoreExperience) {
        this.effects = effects;
        this.health = health;
        this.experience = experience;
        this.level = level;
        this.hunger = hunger;
        this.location = location;
        this.restoreExperience = restoreExperience;
    }

    public PlayerInfo(Player player, boolean excludeInventory) {
        this(Lists.newArrayList((Iterable)player.getActivePotionEffects()), player.getHealth(), player.getExp(), player.getLevel(), player.getFoodLevel(), player.getLocation().clone(), true);
        if (excludeInventory) {
            return;
        }
        InventoryUtil.addToMap(player.getInventory(), this.items);
    }

    public PlayerInfo(Player player, boolean excludeInventory, boolean restoreExperience) {
        this(Lists.newArrayList((Iterable)player.getActivePotionEffects()), player.getHealth(), player.getExp(), player.getLevel(), player.getFoodLevel(), player.getLocation().clone(), restoreExperience);
        if (excludeInventory) {
            return;
        }
        InventoryUtil.addToMap(player.getInventory(), this.items);
    }

    public void restore(Player player) {
        double maxHealth = PlayerUtil.getMaxHealth(player);
        player.addPotionEffects(this.effects);
        player.setHealth(Math.min(this.health, maxHealth));
        if (this.restoreExperience) {
            player.setExp(this.experience);
            player.setLevel(this.level);
        }
        player.setFoodLevel(this.hunger);
        InventoryUtil.fillFromMap(player.getInventory(), this.items);
        InventoryUtil.addOrDrop(player, this.extra);
        player.updateInventory();
    }

    public void restoreWithoutExperience(Player player) {
        double maxHealth = PlayerUtil.getMaxHealth(player);
        player.addPotionEffects(this.effects);
        player.setHealth(Math.min(this.health, maxHealth));
        player.setFoodLevel(this.hunger);
        InventoryUtil.fillFromMap(player.getInventory(), this.items);
        InventoryUtil.addOrDrop(player, this.extra);
        player.updateInventory();
    }

    @Generated
    public Map<String, Map<Integer, ItemStack>> getItems() {
        return this.items;
    }

    @Generated
    public List<PotionEffect> getEffects() {
        return this.effects;
    }

    @Generated
    public double getHealth() {
        return this.health;
    }

    @Generated
    public float getExperience() {
        return this.experience;
    }

    @Generated
    public int getLevel() {
        return this.level;
    }

    @Generated
    public int getHunger() {
        return this.hunger;
    }

    @Generated
    public boolean isRestoreExperience() {
        return this.restoreExperience;
    }

    @Generated
    public List<ItemStack> getExtra() {
        return this.extra;
    }

    @Generated
    public Location getLocation() {
        return this.location;
    }

    @Generated
    public void setLocation(Location location) {
        this.location = location;
    }
}

