/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.queue;

import com.google.common.base.Charsets;
import com.meteordevelopments.duels-optimised.shaded.morepaperlib.scheduling.ScheduledTask;
import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.api.event.queue.QueueCreateEvent;
import com.meteordevelopments.duels.api.event.queue.QueueJoinEvent;
import com.meteordevelopments.duels.api.event.queue.QueueLeaveEvent;
import com.meteordevelopments.duels.api.event.queue.QueueRemoveEvent;
import com.meteordevelopments.duels.api.kit.Kit;
import com.meteordevelopments.duels.api.queue.DQueue;
import com.meteordevelopments.duels.api.queue.DQueueManager;
import com.meteordevelopments.duels.arena.ArenaManagerImpl;
import com.meteordevelopments.duels.config.Config;
import com.meteordevelopments.duels.config.Lang;
import com.meteordevelopments.duels.data.QueueData;
import com.meteordevelopments.duels.data.UserData;
import com.meteordevelopments.duels.data.UserManagerImpl;
import com.meteordevelopments.duels.duel.DuelManager;
import com.meteordevelopments.duels.hook.hooks.CombatLogXHook;
import com.meteordevelopments.duels.hook.hooks.CombatTagPlusHook;
import com.meteordevelopments.duels.hook.hooks.DeluxeCombatHook;
import com.meteordevelopments.duels.hook.hooks.PvPManagerHook;
import com.meteordevelopments.duels.hook.hooks.VaultHook;
import com.meteordevelopments.duels.hook.hooks.worldguard.WorldGuardHook;
import com.meteordevelopments.duels.kit.KitManagerImpl;
import com.meteordevelopments.duels.kit.edit.KitEditManager;
import com.meteordevelopments.duels.queue.Queue;
import com.meteordevelopments.duels.queue.QueueEntry;
import com.meteordevelopments.duels.setting.Settings;
import com.meteordevelopments.duels.shaded.jackson.core.type.TypeReference;
import com.meteordevelopments.duels.spectate.SpectateManagerImpl;
import com.meteordevelopments.duels.util.Loadable;
import com.meteordevelopments.duels.util.Log;
import com.meteordevelopments.duels.util.NumberUtil;
import com.meteordevelopments.duels.util.compat.Items;
import com.meteordevelopments.duels.util.gui.MultiPageGui;
import com.meteordevelopments.duels.util.inventory.InventoryUtil;
import com.meteordevelopments.duels.util.inventory.ItemBuilder;
import com.meteordevelopments.duels.util.io.FileUtil;
import com.meteordevelopments.duels.util.json.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QueueManager
implements Loadable,
DQueueManager,
Listener {
    private static final String FILE_NAME = "queues.json";
    private static final String QUEUES_LOADED = "&2Loaded %s queue(s).";
    private final DuelsPlugin plugin;
    private final Config config;
    private final Lang lang;
    private final UserManagerImpl userManager;
    private final KitManagerImpl kitManager;
    private final ArenaManagerImpl arenaManager;
    private final SpectateManagerImpl spectateManager;
    private final DuelManager duelManager;
    private final File file;
    private final List<Queue> queues = new ArrayList<Queue>();
    private CombatTagPlusHook combatTagPlus;
    private PvPManagerHook pvpManager;
    private DeluxeCombatHook deluxeCombat;
    private WorldGuardHook worldGuard;
    private CombatLogXHook combatLogX;
    private VaultHook vault;
    private ScheduledTask queueTask;
    private MultiPageGui<DuelsPlugin> gui;

    public QueueManager(DuelsPlugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfiguration();
        this.lang = plugin.getLang();
        this.userManager = plugin.getUserManager();
        this.kitManager = plugin.getKitManager();
        this.arenaManager = plugin.getArenaManager();
        this.spectateManager = plugin.getSpectateManager();
        this.duelManager = plugin.getDuelManager();
        this.file = new File(plugin.getDataFolder(), FILE_NAME);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    private boolean canFight(Kit kit, UserData first, UserData second) {
        if (!this.config.isRatingEnabled()) {
            return true;
        }
        if (first != null && second != null) {
            int firstRating = first.getRatingUnsafe(kit);
            int secondRating = second.getRatingUnsafe(kit);
            int kFactor = this.config.getKFactor();
            int maxDifference = this.config.getMaxDifference();
            return firstRating - secondRating <= maxDifference && secondRating - firstRating <= maxDifference && NumberUtil.getChange(kFactor, firstRating, secondRating) != 0 && NumberUtil.getChange(kFactor, secondRating, firstRating) != 0;
        }
        return false;
    }

    @Override
    public void handleLoad() throws IOException {
        this.gui = new MultiPageGui<DuelsPlugin>(this.plugin, this.lang.getMessage("GUI.queues.title"), this.config.getQueuesRows(), this.queues);
        this.gui.setSpaceFiller(Items.from(this.config.getQueuesFillerType(), this.config.getQueuesFillerData()));
        this.gui.setPrevButton(ItemBuilder.of(Material.PAPER).name(this.lang.getMessage("GUI.queues.buttons.previous-page.name"), this.lang).build());
        this.gui.setNextButton(ItemBuilder.of(Material.PAPER).name(this.lang.getMessage("GUI.queues.buttons.next-page.name"), this.lang).build());
        this.gui.setEmptyIndicator(ItemBuilder.of(Material.PAPER).name(this.lang.getMessage("GUI.queues.buttons.empty.name"), this.lang).build());
        this.plugin.getGuiListener().addGui(this.gui);
        if (FileUtil.checkNonEmpty(this.file, true)) {
            try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(this.file.toPath(), new OpenOption[0]), Charsets.UTF_8);){
                List<QueueData> data = JsonUtil.getObjectMapper().readValue((Reader)reader, new TypeReference<List<QueueData>>(this){});
                if (data != null) {
                    data.forEach(queueData -> {
                        Queue queue = queueData.toQueue(this.plugin);
                        if (queue != null && !this.queues.contains(queue)) {
                            this.queues.add(queue);
                        }
                    });
                }
            }
        }
        DuelsPlugin.sendMessage(String.format(QUEUES_LOADED, this.queues.size()));
        this.gui.calculatePages();
        this.combatTagPlus = this.plugin.getHookManager().getHook(CombatTagPlusHook.class);
        this.pvpManager = this.plugin.getHookManager().getHook(PvPManagerHook.class);
        this.deluxeCombat = this.plugin.getHookManager().getHook(DeluxeCombatHook.class);
        this.combatLogX = this.plugin.getHookManager().getHook(CombatLogXHook.class);
        this.worldGuard = this.plugin.getHookManager().getHook(WorldGuardHook.class);
        this.vault = this.plugin.getHookManager().getHook(VaultHook.class);
        this.queueTask = this.plugin.doSyncRepeat(() -> {
            boolean update = false;
            for (Queue queue : this.queues) {
                HashSet<QueueEntry> remove = new HashSet<QueueEntry>();
                int size = Math.max(1, queue.getTeamSize());
                ArrayList<QueueEntry> entries = new ArrayList<QueueEntry>(queue.getPlayers());
                block1: for (int i = 0; i <= entries.size() - size && !update; ++i) {
                    ArrayList<QueueEntry> firstGroup = new ArrayList<QueueEntry>();
                    boolean skipI = false;
                    for (int k = 0; k < size; ++k) {
                        QueueEntry e = (QueueEntry)entries.get(i + k);
                        if (remove.contains(e)) {
                            skipI = true;
                            break;
                        }
                        firstGroup.add(e);
                    }
                    if (skipI) continue;
                    for (int j = i + size; j <= entries.size() - size; ++j) {
                        ArrayList<Object> secondGroup = new ArrayList<Object>();
                        boolean ok = true;
                        for (int k = 0; k < size; ++k) {
                            QueueEntry e = (QueueEntry)entries.get(j + k);
                            if (remove.contains(e)) {
                                ok = false;
                                break;
                            }
                            secondGroup.add(e);
                        }
                        if (!ok) continue;
                        boolean compatible = true;
                        for (QueueEntry a : firstGroup) {
                            for (QueueEntry queueEntry : secondGroup) {
                                if (this.canFight(queue.getKit(), this.userManager.get(a.getPlayer()), this.userManager.get(queueEntry.getPlayer()))) continue;
                                compatible = false;
                                break;
                            }
                            if (compatible) continue;
                            break;
                        }
                        if (!compatible) continue;
                        Settings setting = new Settings(this.plugin);
                        if (queue.getKit() != null) {
                            setting.setKit(this.kitManager.get(queue.getKit().getName()));
                        } else {
                            setting.setOwnInventory(true);
                        }
                        setting.setBet(queue.getBet());
                        ArrayList<Player> firstPlayers = new ArrayList<Player>();
                        ArrayList<Player> secondPlayers = new ArrayList<Player>();
                        for (QueueEntry e : firstGroup) {
                            Player p2 = e.getPlayer();
                            firstPlayers.add(p2);
                            setting.getCache().put(p2.getUniqueId(), e.getInfo());
                        }
                        for (QueueEntry e : secondGroup) {
                            Player p2 = e.getPlayer();
                            secondPlayers.add(p2);
                            setting.getCache().put(p2.getUniqueId(), e.getInfo());
                        }
                        setting.setSenderParty(null);
                        setting.setTargetParty(null);
                        String string = queue.getKit() != null ? queue.getKit().getName() : this.lang.getMessage("GENERAL.none");
                        firstPlayers.forEach(p -> this.lang.sendMessage((CommandSender)p, "QUEUE.found-opponent", "name", ((Player)secondPlayers.getFirst()).getName(), "kit", kit, "bet_amount", queue.getBet()));
                        secondPlayers.forEach(p -> this.lang.sendMessage((CommandSender)p, "QUEUE.found-opponent", "name", ((Player)firstPlayers.getFirst()).getName(), "kit", kit, "bet_amount", queue.getBet()));
                        this.duelManager.startMatch(firstPlayers, secondPlayers, setting, null, queue);
                        remove.addAll(firstGroup);
                        remove.addAll(secondGroup);
                        update = true;
                        continue block1;
                    }
                }
                if (!queue.removeAll(remove) || update) continue;
                update = true;
            }
            if (update) {
                this.gui.calculatePages();
            }
        }, 20L, 40L);
    }

    @Override
    public void handleUnload() {
        this.plugin.cancelTask(this.queueTask);
        if (this.gui != null) {
            this.plugin.getGuiListener().removeGui(this.gui);
        }
        this.queues.clear();
    }

    private void saveQueues() {
        ArrayList<QueueData> data = new ArrayList<QueueData>();
        for (Queue queue : this.queues) {
            data.add(new QueueData(queue));
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(this.file.toPath(), new OpenOption[0]), Charsets.UTF_8);){
            JsonUtil.getObjectWriter().writeValue(writer, data);
            ((Writer)writer).flush();
        }
        catch (IOException ex) {
            Log.error(this, ex.getMessage(), ex);
        }
    }

    @Override
    @Nullable
    public Queue get(@Nullable Kit kit, int bet) {
        return this.queues.stream().filter(queue -> Objects.equals(kit, queue.getKit()) && queue.getBet() == bet).findFirst().orElse(null);
    }

    @Override
    @Nullable
    public Queue get(@NotNull Player player) {
        Objects.requireNonNull(player, "player");
        return this.queues.stream().filter(queue -> queue.isInQueue(player)).findFirst().orElse(null);
    }

    @Nullable
    public Queue randomQueue() {
        return !this.queues.isEmpty() ? this.queues.get(ThreadLocalRandom.current().nextInt(this.queues.size())) : null;
    }

    @Nullable
    public Queue getByName(String name) {
        return this.queues.stream().filter(queue -> queue.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public List<String> getQueueNames() {
        return this.queues.stream().map(Queue::getName).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public Queue create(@Nullable CommandSender source, @Nullable Kit kit, int bet) {
        return this.create(source, "Unnamed", kit, bet, 1);
    }

    public Queue create(@Nullable CommandSender source, @Nullable Kit kit, int bet, int teamSize) {
        return this.create(source, "Unnamed", kit, bet, teamSize);
    }

    public Queue create(@Nullable CommandSender source, String name, @Nullable Kit kit, int bet, int teamSize) {
        Queue queue = new Queue(this.plugin, name, kit, bet, Math.max(1, teamSize));
        if (this.queues.contains(queue)) {
            return null;
        }
        this.queues.add(queue);
        this.saveQueues();
        QueueCreateEvent event = new QueueCreateEvent(source, queue);
        Bukkit.getPluginManager().callEvent((Event)event);
        this.gui.calculatePages();
        return queue;
    }

    @Override
    @Nullable
    public Queue create(@Nullable Kit kit, int bet) {
        return this.create(null, "Unnamed", kit, bet, 1);
    }

    @Override
    @Nullable
    public Queue remove(@Nullable CommandSender source, @Nullable Kit kit, int bet) {
        return this.remove(source, this.get(kit, bet));
    }

    @Override
    @Nullable
    public Queue remove(@Nullable Kit kit, int bet) {
        return this.remove(null, kit, bet);
    }

    @Override
    @NotNull
    public List<DQueue> getQueues() {
        return Collections.unmodifiableList(this.queues);
    }

    @Override
    public boolean isInQueue(@NotNull Player player) {
        Objects.requireNonNull(player, "player");
        return this.queues.stream().anyMatch(queue -> queue.isInQueue(player));
    }

    @Override
    public boolean addToQueue(@NotNull Player player, @NotNull DQueue queue) {
        Objects.requireNonNull(player, "player");
        Objects.requireNonNull(queue, "queue");
        return this.queue(player, (Queue)queue);
    }

    @Override
    @Nullable
    public DQueue removeFromQueue(@NotNull Player player) {
        Objects.requireNonNull(player, "player");
        return this.remove(player);
    }

    public Queue remove(CommandSender source, Queue queue) {
        if (queue == null || !this.queues.remove(queue)) {
            return null;
        }
        this.saveQueues();
        queue.getPlayers().forEach(entry -> this.lang.sendMessage((CommandSender)entry.getPlayer(), "QUEUE.remove", new Object[0]));
        queue.getPlayers().clear();
        queue.setRemoved(true);
        QueueRemoveEvent event = new QueueRemoveEvent(source, queue);
        Bukkit.getPluginManager().callEvent((Event)event);
        this.gui.calculatePages();
        return queue;
    }

    public boolean queue(Player player, Queue queue) {
        Queue found = this.get(player);
        if (found != null) {
            if (found.equals(queue)) {
                queue.removePlayer(player);
                this.lang.sendMessage((CommandSender)player, "QUEUE.remove", new Object[0]);
                return false;
            }
            this.lang.sendMessage((CommandSender)player, "ERROR.queue.already-in", new Object[0]);
            return false;
        }
        if (this.spectateManager.isSpectating(player)) {
            this.lang.sendMessage((CommandSender)player, "ERROR.duel.already-spectating.sender", new Object[0]);
            return false;
        }
        if (this.arenaManager.isInMatch(player)) {
            this.lang.sendMessage((CommandSender)player, "ERROR.duel.already-in-match.sender", new Object[0]);
            return false;
        }
        if (this.config.isRequiresClearedInventory() && InventoryUtil.hasItem(player)) {
            this.lang.sendMessage((CommandSender)player, "ERROR.duel.inventory-not-empty", new Object[0]);
            return false;
        }
        if (this.config.isPreventCreativeMode() && player.getGameMode() == GameMode.CREATIVE) {
            this.lang.sendMessage((CommandSender)player, "ERROR.duel.in-creative-mode", new Object[0]);
            return false;
        }
        if (this.combatTagPlus != null && this.combatTagPlus.isTagged(player) || this.pvpManager != null && this.pvpManager.isTagged(player) || this.deluxeCombat != null && this.deluxeCombat.isTagged(player) || this.combatLogX != null && this.combatLogX.isTagged(player)) {
            this.lang.sendMessage((CommandSender)player, "ERROR.duel.is-tagged", new Object[0]);
            return false;
        }
        String duelzone = null;
        if (this.worldGuard != null && this.config.isDuelzoneEnabled() && (duelzone = this.worldGuard.findDuelZone(player)) == null) {
            this.lang.sendMessage((CommandSender)player, "ERROR.duel.not-in-duelzone", "regions", this.config.getDuelzones());
            return false;
        }
        if (queue.getBet() > 0 && this.vault != null && !this.vault.has(queue.getBet(), player)) {
            this.lang.sendMessage((CommandSender)player, "ERROR.queue.not-enough-money", "bet_amount", queue.getBet());
            return false;
        }
        QueueJoinEvent event = new QueueJoinEvent(player, (DQueue)queue);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        queue.addPlayer(new QueueEntry(player, player.getLocation().clone(), duelzone));
        KitEditManager kitEditManager = KitEditManager.getInstance();
        if (kitEditManager != null) {
            kitEditManager.checkAndAbortIfInQueueOrMatch(player);
        }
        String kit = queue.getKit() != null ? queue.getKit().getName() : this.lang.getMessage("GENERAL.none");
        this.lang.sendMessage((CommandSender)player, "QUEUE.add", "name", queue.getName(), "kit", kit, "bet_amount", queue.getBet());
        return true;
    }

    public Queue remove(Player player) {
        for (Queue queue : this.queues) {
            if (!queue.removePlayer(player)) continue;
            QueueLeaveEvent event = new QueueLeaveEvent(player, (DQueue)queue);
            Bukkit.getPluginManager().callEvent((Event)event);
            this.lang.sendMessage((CommandSender)player, "QUEUE.remove", new Object[0]);
            return queue;
        }
        return null;
    }

    @EventHandler
    public void on(PlayerQuitEvent event) {
        this.remove(event.getPlayer());
    }

    @EventHandler(ignoreCancelled=true)
    public void on(PlayerCommandPreprocessEvent event) {
        String command = event.getMessage().substring(1).split(" ")[0].toLowerCase();
        if (!this.isInQueue(event.getPlayer()) || !this.config.getQueueBlacklistedCommands().contains(command)) {
            return;
        }
        event.setCancelled(true);
        this.lang.sendMessage((CommandSender)event.getPlayer(), "QUEUE.prevent.command", "command", event.getMessage());
    }

    @Generated
    public MultiPageGui<DuelsPlugin> getGui() {
        return this.gui;
    }
}

