/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.shaded.jackson.databind.deser.std;

import com.meteordevelopments.duels.shaded.jackson.databind.DeserializationContext;
import com.meteordevelopments.duels.shaded.jackson.databind.JsonDeserializer;
import com.meteordevelopments.duels.shaded.jackson.databind.JsonMappingException;
import com.meteordevelopments.duels.shaded.jackson.databind.deser.std.AtomicBooleanDeserializer;
import com.meteordevelopments.duels.shaded.jackson.databind.deser.std.AtomicIntegerDeserializer;
import com.meteordevelopments.duels.shaded.jackson.databind.deser.std.AtomicLongDeserializer;
import com.meteordevelopments.duels.shaded.jackson.databind.deser.std.ByteBufferDeserializer;
import com.meteordevelopments.duels.shaded.jackson.databind.deser.std.FromStringDeserializer;
import com.meteordevelopments.duels.shaded.jackson.databind.deser.std.NullifyingDeserializer;
import com.meteordevelopments.duels.shaded.jackson.databind.deser.std.StackTraceElementDeserializer;
import com.meteordevelopments.duels.shaded.jackson.databind.deser.std.ThreadGroupDeserializer;
import com.meteordevelopments.duels.shaded.jackson.databind.deser.std.UUIDDeserializer;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class JdkDeserializers {
    private static final HashSet<String> _classNames;

    public static JsonDeserializer<?> find(DeserializationContext ctxt, Class<?> rawType, String clsName) throws JsonMappingException {
        if (_classNames.contains(clsName)) {
            FromStringDeserializer<?> d = FromStringDeserializer.findDeserializer(rawType);
            if (d != null) {
                return d;
            }
            if (rawType == UUID.class) {
                return new UUIDDeserializer();
            }
            if (rawType == StackTraceElement.class) {
                return StackTraceElementDeserializer.construct(ctxt);
            }
            if (rawType == AtomicBoolean.class) {
                return new AtomicBooleanDeserializer();
            }
            if (rawType == AtomicInteger.class) {
                return new AtomicIntegerDeserializer();
            }
            if (rawType == AtomicLong.class) {
                return new AtomicLongDeserializer();
            }
            if (rawType == ByteBuffer.class) {
                return new ByteBufferDeserializer();
            }
            if (rawType == Void.class) {
                return NullifyingDeserializer.instance;
            }
            if (rawType == ThreadGroup.class) {
                return new ThreadGroupDeserializer();
            }
        }
        return null;
    }

    public static boolean hasDeserializerFor(Class<?> rawType) {
        return _classNames.contains(rawType.getName());
    }

    static {
        Class[] types;
        _classNames = new HashSet();
        for (Class clazz : types = new Class[]{UUID.class, AtomicBoolean.class, AtomicInteger.class, AtomicLong.class, StackTraceElement.class, ByteBuffer.class, Void.class, ThreadGroup.class}) {
            _classNames.add(clazz.getName());
        }
        for (Class clazz : FromStringDeserializer.types()) {
            _classNames.add(clazz.getName());
        }
    }
}

